/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.net.URI;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.client.RemoteCollectionProxy;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.RemoteCollectionProxyFactory;
import oracle.pgx.config.LinkTemplate;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class RemoteCollectionProxyFactoryImpl
implements RemoteCollectionProxyFactory {
    private final ClientContext context;
    private final URI baseUri;

    public RemoteCollectionProxyFactoryImpl(ClientContext context, URI baseUri) {
        this.context = context;
        this.baseUri = baseUri;
    }

    public CollectionProxy createRemoteCollectionProxy(SessionContext sessionContext, String collectionProxyUUID, CollectionType collectionType, int size, PropertyType valueType, Boolean wrappedEntities) {
        String url = LinkTemplate.COLLECTION_PROXY_SELF.generateUrl(this.baseUri, new Object[0]);
        CloseableHttpClient httpClient = this.context.getHttpClient();
        Executor executor = RemoteUtils.newHttpExecutor(httpClient, url, sessionContext, this.context.getCsrfToken(), this.context.getClientStickyCookie());
        return new RemoteCollectionProxy(executor, url, collectionProxyUUID, collectionType, size, this.context.getConfig().getPrefetchSize(), valueType, wrappedEntities);
    }
}

