/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermList;
import org.spoofax.terms.util.TermUtils;

public abstract class AbstractStrategoList
extends StrategoTerm
implements IStrategoList {
    public AbstractStrategoList(@Nullable IStrategoList annotations) {
        super(annotations);
    }

    @Override
    public TermType getType() {
        return TermType.LIST;
    }

    @Override
    protected int hashFunction() {
        if (this.isEmpty()) {
            return 1;
        }
        int prime = 31;
        int result = 31 * this.head().hashCode();
        Iterator<IStrategoTerm> iterator = this.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            IStrategoTerm head = iterator.next();
            result = 31 * result + head.hashCode();
        }
        return result;
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        if (!this.isEmpty()) {
            pp.println("[");
            pp.indent(2);
            Iterator<IStrategoTerm> iter = this.iterator();
            iter.next().prettyPrint(pp);
            while (iter.hasNext()) {
                IStrategoTerm element = iter.next();
                pp.print(",");
                pp.nextIndentOff();
                element.prettyPrint(pp);
                pp.println("");
            }
            pp.println("");
            pp.print("]");
            pp.outdent(2);
        } else {
            pp.print("[]");
        }
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append('[');
        if (!this.isEmpty()) {
            if (maxDepth == 0) {
                output.append("...");
            } else {
                Iterator<IStrategoTerm> iter = this.iterator();
                iter.next().writeAsString(output, maxDepth - 1);
                while (iter.hasNext()) {
                    IStrategoTerm element = iter.next();
                    output.append(',');
                    element.writeAsString(output, maxDepth - 1);
                }
            }
        }
        output.append(']');
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return TermList.ofUnsafe(this.getAllSubterms());
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        if (this == second) {
            return true;
        }
        if (!TermUtils.isList(second)) {
            return false;
        }
        if (this.getSubtermCount() != second.getSubtermCount()) {
            return false;
        }
        IStrategoList snd = (IStrategoList)second;
        if (!this.isEmpty()) {
            IStrategoTerm head2;
            IStrategoTerm head = this.head();
            if (head != (head2 = snd.head()) && !head.match(head2)) {
                return false;
            }
            IStrategoList tail = this.tail();
            IStrategoList tail2 = snd.tail();
            IStrategoList cons = tail;
            IStrategoList cons2 = tail2;
            while (!cons.isEmpty()) {
                IStrategoTerm consHead = cons.head();
                IStrategoTerm cons2Head = cons2.head();
                if (!cons.getAnnotations().match(cons2.getAnnotations())) {
                    return false;
                }
                if (consHead != cons2Head && !consHead.match(cons2Head)) {
                    return false;
                }
                cons = cons.tail();
                cons2 = cons2.tail();
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }
}

