/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ITokens;
import mb.jsglr.shared.ImploderAttachment;
import mb.jsglr.shared.Token;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.StrategoSubList;
import org.spoofax.terms.attachments.ParentAttachment;

public class LayoutStructure {
    private final ISimpleTerm node;
    private final ISimpleTerm listParent;
    private final ITokens tokens;
    private IToken suffixStart;
    private IToken commentsAfterExclEnd;
    private IToken suffixSeparationExclEnd;
    private IToken prefixEnd;
    private IToken commentsBeforeStart;
    private IToken prefixSeparationStart;

    public LayoutStructure(IStrategoTerm node) {
        this.node = ImploderAttachment.getImploderOrigin(node);
        this.listParent = this.getParentList();
        this.assertImploderInfo();
        this.tokens = ImploderAttachment.getLeftToken(node).getTokenizer();
        this.analyzeSuffix();
        this.analyzePrefix();
    }

    private void assertImploderInfo() {
        assert (this.node != null) : "Error: Layout analysis can only be applied to nodes with associated origin term";
        if (this.listParent != null) {
            assert (ImploderAttachment.hasImploderOrigin(this.listParent)) : "Unexpected Error: list-parent of imploder-origin must have imploder info";
            int i = 0;
            while (i < this.listParent.getSubtermCount()) {
                assert (ImploderAttachment.hasImploderOrigin(this.listParent.getSubterm(i))) : "Unexpected Error: subterms of origin-list must have imploder info";
                ++i;
            }
        }
    }

    public String getCommentsBefore() {
        String layoutPrefix = this.getLayoutPrefix();
        return this.trimWsPreservingLastNewline(layoutPrefix);
    }

    public String getCommentsAfter() {
        String layoutSuffix = this.getLayoutSuffix();
        return this.trimWsPreservingLastNewline(layoutSuffix);
    }

    public String getLayoutPrefix() {
        return this.layoutFragmentWithOutSeparator(this.commentsBeforeStart, this.prefixEnd);
    }

    public String getLayoutSuffix() {
        return this.layoutFragmentWithOutSeparator(this.suffixStart, this.commentsAfterExclEnd.getTokenBefore());
    }

    public String getTextWithLayout() {
        return String.valueOf(this.getTokenString(this.commentsBeforeStart, ImploderAttachment.getRightToken(this.node))) + this.getLayoutSuffix();
    }

    public String getIndentation() {
        String indent = this.getIndentString();
        assert (indent.replaceAll("[ \t]", "").equals(""));
        return indent;
    }

    public String getSeparation() {
        return this.getSeparationString();
    }

    public int getDeletionStartOffset() {
        if (this.isLastListElement()) {
            assert (this.prefixSeparationStart != null);
            return this.prefixSeparationStart.getStartOffset();
        }
        return this.getInsertBeforeOffset();
    }

    public int getDeletionEndOffset() {
        if (this.isLastListElement()) {
            int deletionEndOffset = this.getInsertAtEndOffset() - 1;
            return this.keepNewlineOfLineComment(deletionEndOffset);
        }
        if (this.suffixSeparationExclEnd != null) {
            int deletionEndOffset = this.suffixSeparationExclEnd.getStartOffset() - 1;
            return deletionEndOffset;
        }
        return ImploderAttachment.getRightToken(this.node).getEndOffset();
    }

    public int getInsertBeforeOffset() {
        int offset = this.commentsBeforeStart.getStartOffset();
        String input = this.tokens.getInput();
        while (offset < input.length() && (input.charAt(offset) == ' ' || input.charAt(offset) == '\t')) {
            ++offset;
        }
        return offset;
    }

    public int getInsertAtEndOffset() {
        IToken token = this.commentsAfterExclEnd;
        if (token != null) {
            if (this.node.isList() && this.node.getSubtermCount() == 0) {
                IToken previousToken = token.getTokenBefore();
                while (this.isLayout(previousToken)) {
                    token = previousToken;
                }
            }
            return token.getStartOffset();
        }
        return ImploderAttachment.getRightToken(this.node).getEndOffset() + 1;
    }

    private String layoutFragmentWithOutSeparator(IToken loStart, IToken loEnd) {
        String result = "";
        IToken token = loStart;
        while (token != null && token.getStartOffset() <= loEnd.getStartOffset()) {
            if (this.isLayout(token)) {
                result = String.valueOf(result) + this.getTokenString(token);
            } else {
                assert (this.isSeparatorToken(token));
                result = String.valueOf(result) + this.createSpaces(token.getLength());
            }
            token = token.getTokenAfter();
        }
        return result;
    }

    private String createSpaces(int length) {
        String spaces = "";
        int i = 0;
        while (i < length) {
            spaces = String.valueOf(spaces) + " ";
            ++i;
        }
        return spaces;
    }

    private int keepNewlineOfLineComment(int deletionEndOffset) {
        while (Character.isWhitespace(this.getCharAt(deletionEndOffset))) {
            --deletionEndOffset;
        }
        return deletionEndOffset;
    }

    private void analyzePrefix() {
        IToken prefixSeparator;
        IToken previousToken;
        this.prefixEnd = ImploderAttachment.getLeftToken(this.node).getTokenBefore();
        IToken prefixStart = this.getPrefixStart(this.prefixEnd);
        this.commentsBeforeStart = ImploderAttachment.getLeftToken(this.node);
        IToken token = this.commentsBeforeStart.getTokenBefore();
        int lastNonEmptyLine = ImploderAttachment.getLeftToken(this.node).getLine();
        int preceedingAstLine = -1;
        IToken iToken = previousToken = prefixStart != null ? prefixStart.getTokenBefore() : null;
        if (previousToken != null) {
            preceedingAstLine = previousToken.getEndLine();
        }
        boolean sameLineSiblings = this.preceedingSibEndLine() == ImploderAttachment.getLeftToken(this.node).getLine();
        while (token != null && prefixStart != null && token.getStartOffset() >= prefixStart.getStartOffset()) {
            if (this.isComment(token)) {
                int commentEndLine = token.getEndLine();
                int commentStartLine = token.getLine();
                if (lastNonEmptyLine - commentEndLine > 1 || preceedingAstLine == commentStartLine && !sameLineSiblings) break;
                this.commentsBeforeStart = token;
                lastNonEmptyLine = token.getLine();
            }
            if (this.isSeparatorToken(token.getTokenBefore())) break;
            if (token == prefixStart && sameLineSiblings) {
                this.commentsBeforeStart = ImploderAttachment.getLeftToken(this.node);
                break;
            }
            token = token.getTokenBefore();
        }
        this.prefixSeparationStart = (prefixSeparator = this.getSeparator(prefixStart, this.prefixEnd)) == null ? this.commentsBeforeStart : prefixSeparator;
        while (this.isWhitespace(this.prefixSeparationStart.getTokenBefore())) {
            this.prefixSeparationStart = this.prefixSeparationStart.getTokenBefore();
        }
    }

    private void analyzeSuffix() {
        IToken suffixSeparator;
        this.suffixStart = ImploderAttachment.getRightToken(this.node).getTokenAfter();
        IToken suffixEnd = this.getSuffixEnd(this.suffixStart);
        IToken nextToken = suffixEnd.getTokenAfter();
        boolean sameLineSiblings = this.tokensOnSameLine(this.suffixStart.getTokenBefore(), nextToken) && !this.isLastListElement();
        IToken token = this.commentsAfterExclEnd = this.suffixStart;
        while (token != null && nextToken != null && token.getStartOffset() <= nextToken.getStartOffset()) {
            if (token.getLine() != ImploderAttachment.getRightToken(this.node).getEndLine()) break;
            if (sameLineSiblings && token == nextToken) {
                this.commentsAfterExclEnd = this.suffixStart;
                break;
            }
            if (sameLineSiblings && this.isSeparatorToken(token)) break;
            if (this.isComment(token)) {
                this.commentsAfterExclEnd = token.getTokenAfter();
            }
            token = token.getTokenAfter();
        }
        this.suffixSeparationExclEnd = (suffixSeparator = this.getSeparator(this.suffixStart, suffixEnd)) == null || this.commentsAfterExclEnd.getStartOffset() > suffixSeparator.getTokenAfter().getStartOffset() ? this.commentsAfterExclEnd : suffixSeparator.getTokenAfter();
        while (this.isWhitespace(this.suffixSeparationExclEnd)) {
            this.suffixSeparationExclEnd = this.suffixSeparationExclEnd.getTokenAfter();
        }
    }

    private boolean isFirstListElement() {
        if (this.listParent == null) {
            return false;
        }
        if (this.node instanceof StrategoSubList) {
            return ((StrategoSubList)this.node).getIndexStart() == 0;
        }
        return this.listParent.getSubterm(0) == this.node;
    }

    private int preceedingSibEndLine() {
        if (this.isFirstListElement()) {
            return -1;
        }
        if (this.listParent == null) {
            return -1;
        }
        int indexPreceedingSib = -1;
        if (this.node instanceof StrategoSubList) {
            indexPreceedingSib = ((StrategoSubList)this.node).getIndexStart() - 1;
            assert (this.listParent == ((StrategoSubList)this.node).getCompleteList());
        } else {
            int i = 1;
            while (i < this.listParent.getSubtermCount()) {
                if (this.listParent.getSubterm(i) == this.node) {
                    indexPreceedingSib = i - 1;
                }
                ++i;
            }
        }
        if (indexPreceedingSib == -1) {
            return -1;
        }
        assert (indexPreceedingSib >= 0 && indexPreceedingSib < this.listParent.getSubtermCount());
        ISimpleTerm preceedingNode = this.listParent.getSubterm(indexPreceedingSib);
        if (!ImploderAttachment.hasImploderOrigin(preceedingNode)) {
            return -1;
        }
        return ImploderAttachment.getRightToken(preceedingNode).getEndLine();
    }

    private boolean isLastListElement() {
        if (this.listParent == null) {
            return false;
        }
        if (this.node instanceof StrategoSubList) {
            return ((StrategoSubList)this.node).getIndexEnd() == this.listParent.getSubtermCount() - 1;
        }
        return this.listParent.getSubterm(this.listParent.getSubtermCount() - 1) == this.node;
    }

    private boolean tokensOnSameLine(IToken i, IToken j) {
        if (i != null && j != null) {
            return i.getLine() == j.getLine();
        }
        return false;
    }

    private char getCharAt(int offset) {
        assert (offset < this.tokens.getInput().length());
        return this.tokens.getInput().charAt(offset);
    }

    private IToken getSuffixEnd(IToken suffixStart) {
        IToken suffixEnd = suffixStart;
        while (suffixEnd != null && this.notAssociatedToAstNode(suffixEnd.getTokenAfter())) {
            suffixEnd = suffixEnd.getTokenAfter();
        }
        return suffixEnd;
    }

    private IToken getPrefixStart(IToken prefixEndToken) {
        IToken prefixStart = prefixEndToken;
        while (prefixStart != null && this.notAssociatedToAstNode(prefixStart.getTokenBefore())) {
            prefixStart = prefixStart.getTokenBefore();
        }
        return prefixStart;
    }

    private IToken getSeparator(IToken suffixStart, IToken suffixEnd) {
        IToken token = suffixEnd;
        while (token != null && token.getStartOffset() >= suffixStart.getStartOffset()) {
            if (this.isSeparatorToken(token)) {
                return token;
            }
            token = token.getTokenBefore();
        }
        return null;
    }

    private boolean isSeparatorToken(IToken token) {
        return this.isAssociatedToListParent(token) && !this.isLayout(token);
    }

    private boolean notAssociatedToAstNode(IToken token) {
        return this.isLayout(token) || this.isAssociatedToListParent(token);
    }

    private boolean isWhitespace(IToken token) {
        return this.isLayout(token) && !this.isComment(token);
    }

    private boolean isComment(IToken token) {
        return this.isLayout(token) && !Token.isWhiteSpace(token);
    }

    private boolean isLayout(IToken token) {
        return token != null && token.getKind() == IToken.Kind.TK_LAYOUT;
    }

    private boolean isAssociatedToListParent(IToken token) {
        return token != null && this.listParent != null && token.getAstNode() == this.listParent;
    }

    private IStrategoTerm getParentList() {
        if (this.node instanceof StrategoSubList) {
            return ((StrategoSubList)this.node).getCompleteList();
        }
        if (this.node.isList() && this.node.getSubtermCount() > 0) {
            return (IStrategoTerm)this.node;
        }
        if (ParentAttachment.getParent(this.node) == null) {
            return null;
        }
        return ParentAttachment.getParent(this.node).isList() ? ParentAttachment.getParent(this.node) : null;
    }

    private String trimWsPreservingLastNewline(String layoutSuffix) {
        String commentEnd = "";
        if (layoutSuffix.endsWith("\n")) {
            commentEnd = "\n";
        }
        return String.valueOf(layoutSuffix.trim()) + commentEnd;
    }

    private String getIndentString() {
        int offset = ImploderAttachment.getLeftToken(this.node).getStartOffset();
        String input = this.tokens.getInput();
        String indentation = "";
        int i = offset - 1;
        while (i >= 0) {
            char character = input.charAt(i);
            if (character == '\n') {
                return indentation;
            }
            indentation = character == ' ' || character == '\t' ? String.valueOf(character) + indentation : "";
            --i;
        }
        return indentation;
    }

    public String getSeparationString() {
        if (this.listParent != null && this.listParent.getSubtermCount() > 1) {
            IToken startToken = ImploderAttachment.getRightToken(this.listParent.getSubterm(0));
            IToken endToken = ImploderAttachment.getLeftToken(this.listParent.getSubterm(1));
            return this.getSeparationString(startToken, endToken);
        }
        return null;
    }

    private String getSeparationString(IToken tokenStart, IToken tokenEnd) {
        String separation = "";
        String layoutText = "";
        boolean commentSeen = false;
        boolean commentLine = false;
        IToken token = tokenStart.getTokenAfter();
        while (token != tokenEnd) {
            String tokenText = this.getTokenString(token);
            if (!this.isComment(token)) {
                if (!commentSeen) {
                    separation = String.valueOf(separation) + tokenText;
                } else {
                    layoutText = String.valueOf(layoutText) + tokenText;
                }
            } else {
                commentSeen = true;
                layoutText = "";
                if (tokenText.endsWith("\n")) {
                    layoutText = "\n";
                }
                if (token.getLine() != tokenStart.getEndLine() && token.getEndLine() != tokenEnd.getLine()) {
                    commentLine = true;
                }
            }
            token = token.getTokenAfter();
        }
        if (commentLine) {
            separation = separation.replaceFirst("\n[ \t]*", "");
        }
        return String.valueOf(separation) + layoutText;
    }

    private String getTokenString(IToken token) {
        assert (token != null);
        int startOffset = token.getStartOffset();
        int endOffset = token.getEndOffset();
        return this.tokens.toString(startOffset, endOffset);
    }

    private String getTokenString(IToken tokenStart, IToken tokenEnd) {
        assert (tokenStart != null);
        assert (tokenEnd != null);
        int startOffset = tokenStart.getStartOffset();
        int endOffset = tokenEnd.getEndOffset();
        return this.tokens.toString(startOffset, endOffset);
    }
}

