/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import jakarta.annotation.Nullable;
import java.util.List;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public final class Tools {
    public static boolean isCons(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getCons());
    }

    public static boolean isNil(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getNil());
    }

    public static boolean isSDefT(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getSDefT());
    }

    public static boolean isExtSDef(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getExtSDef());
    }

    public static boolean isAnno(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getAnno());
    }

    public static boolean isOp(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getOp());
    }

    public static boolean isStr(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getStr());
    }

    public static boolean isVar(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getVar());
    }

    public static boolean isExplode(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getExplode());
    }

    public static boolean isWld(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getWld());
    }

    public static boolean isAs(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getAs());
    }

    public static boolean isReal(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getReal());
    }

    public static boolean isInt(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getInt());
    }

    public static boolean isFunType(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getFunType());
    }

    public static boolean isConstType(IStrategoAppl t, IContext env) {
        return TermUtils.isAppl((IStrategoTerm)t, env.getStrategoSignature().getConstType());
    }

    @Deprecated
    @Nullable
    public static IStrategoString stringAt(IStrategoTerm t, int i) {
        return TermUtils.asString(t.getSubterm(i)).orElse(null);
    }

    @Deprecated
    @Nullable
    public static IStrategoAppl applAt(IStrategoTerm t, int i) {
        return TermUtils.asAppl(t.getSubterm(i)).orElse(null);
    }

    @Deprecated
    @Nullable
    public static IStrategoInt intAt(IStrategoTerm t, int i) {
        return TermUtils.asInt(t.getSubterm(i)).orElse(null);
    }

    @Deprecated
    @Nullable
    public static IStrategoList listAt(IStrategoTerm t, int i) {
        return TermUtils.asList(t.getSubterm(i)).orElse(null);
    }

    @Deprecated
    @Nullable
    public static IStrategoReal realAt(IStrategoTerm t, int i) {
        return TermUtils.asReal(t.getSubterm(i)).orElse(null);
    }

    @Deprecated
    public static <T extends IStrategoTerm> T termAt(IStrategoTerm t, int i) {
        return (T)t.getSubterm(i);
    }

    @Deprecated
    public static boolean hasConstructor(IStrategoAppl t, String ctorName) {
        return TermUtils.isAppl((IStrategoTerm)t, ctorName);
    }

    @Deprecated
    public static boolean hasConstructor(IStrategoAppl t, String ctorName, int arity) {
        return TermUtils.isAppl(t, ctorName, arity);
    }

    @Nullable
    @Deprecated
    public static String constructorName(IStrategoTerm t) {
        return TermUtils.asAppl(t).map(a -> a.getConstructor().getName()).orElse(null);
    }

    @Deprecated
    public static boolean isTermString(IStrategoTerm t) {
        return TermUtils.isString(t);
    }

    @Deprecated
    public static boolean isTermList(IStrategoTerm t) {
        return TermUtils.isList(t);
    }

    @Deprecated
    public static boolean isTermInt(IStrategoTerm t) {
        return TermUtils.isInt(t);
    }

    @Deprecated
    public static boolean isTermReal(IStrategoTerm t) {
        return TermUtils.isReal(t);
    }

    @Deprecated
    public static boolean isTermAppl(IStrategoTerm t) {
        return TermUtils.isAppl(t);
    }

    @Deprecated
    public static boolean isTermTuple(IStrategoTerm t) {
        return TermUtils.isTuple(t);
    }

    @Deprecated
    public static int asJavaInt(IStrategoTerm term) {
        return TermUtils.toJavaInt(term);
    }

    @Deprecated
    public static int javaInt(IStrategoTerm term) {
        return TermUtils.toJavaInt(term);
    }

    @Deprecated
    public static int javaIntAt(IStrategoTerm t, int i) {
        return TermUtils.toJavaIntAt(t, i);
    }

    @Deprecated
    public static double asJavaDouble(IStrategoTerm term) {
        return TermUtils.toJavaReal(term);
    }

    @Deprecated
    public static double javaDoubleAt(IStrategoTerm t, int i) {
        return TermUtils.toJavaRealAt(t, i);
    }

    @Deprecated
    public static String asJavaString(IStrategoTerm term) {
        return TermUtils.toJavaString(term);
    }

    @Deprecated
    public static String javaString(IStrategoTerm t) {
        return TermUtils.toJavaString(t);
    }

    @Deprecated
    public static String javaStringAt(IStrategoTerm t, int i) {
        return TermUtils.toJavaStringAt(t, i);
    }

    @Deprecated
    public static List<IStrategoTerm> asJavaList(IStrategoTerm term) {
        return TermUtils.toJavaList(term);
    }

    @Deprecated
    public static List<IStrategoTerm> javaListAt(IStrategoTerm term, int index) {
        return TermUtils.toJavaListAt(term, index);
    }
}

