/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.dynamicclassloading;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.language.ILanguageCache;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoader;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoadingFacet;
import org.metaborg.spoofax.core.dynamicclassloading.IDynamicClassLoadingService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class DynamicClassLoadingService
implements IDynamicClassLoadingService,
ILanguageCache {
    private static final ILogger logger = LoggerUtils.logger(DynamicClassLoadingService.class);
    private final IResourceService resourceService;
    private final Set<ClassLoader> additionalClassLoaders;
    private final Map<ILanguageComponent, ClassLoader> classLoaderCache = new HashMap<ILanguageComponent, ClassLoader>();
    private final Map<ILanguageComponent, Map<Class<?>, ServiceLoader<?>>> serviceLoaderCache = new HashMap();
    private final Injector injector;

    @Inject
    public DynamicClassLoadingService(IResourceService resourceService, Set<ClassLoader> additionalClassLoaders, Injector injector) {
        this.resourceService = resourceService;
        this.additionalClassLoaders = additionalClassLoaders;
        this.injector = injector;
    }

    @Override
    public <T> T loadClass(ILanguageComponent component, String className, Class<T> expectedType) {
        Object instance;
        Class<?> theClass;
        ClassLoader classLoader = this.classLoader(component);
        try {
            logger.trace("Loading outliner class");
            theClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new MetaborgRuntimeException("Given class was not found: " + className, e);
        }
        try {
            logger.trace("Instantiating class " + className);
            instance = theClass.newInstance();
            this.injector.injectMembers(instance);
        }
        catch (InstantiationException e) {
            throw new MetaborgRuntimeException("Given class was not instantiable: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new MetaborgRuntimeException("Given class was not accessible: " + className, e);
        }
        catch (ClassCastException e) {
            throw new MetaborgRuntimeException("Given class does not implement required interface: " + className, e);
        }
        logger.trace("Successfully loaded and instantiated class " + className);
        return (T)instance;
    }

    @Override
    public <T> List<T> loadClasses(ILanguageComponent component, Class<T> type) throws MetaborgException {
        Map<Object, Object> serviceLoaderCacheLevel2;
        if (this.serviceLoaderCache.containsKey(component)) {
            serviceLoaderCacheLevel2 = this.serviceLoaderCache.get(component);
            if (serviceLoaderCacheLevel2.containsKey(type)) {
                ServiceLoader serviceLoader = (ServiceLoader)serviceLoaderCacheLevel2.get(type);
                return this.initializeInjectionFields(serviceLoader.iterator());
            }
        } else {
            serviceLoaderCacheLevel2 = new HashMap();
            this.serviceLoaderCache.put(component, serviceLoaderCacheLevel2);
        }
        ClassLoader classLoader = this.classLoader(component);
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type, classLoader);
        serviceLoaderCacheLevel2.put(type, serviceLoader);
        return this.initializeInjectionFields(serviceLoader.iterator());
    }

    private <T> List<T> initializeInjectionFields(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            T instance = iterator.next();
            this.injector.injectMembers(instance);
            result.add(instance);
        }
        return result;
    }

    private ClassLoader classLoader(ILanguageComponent component) {
        if (this.classLoaderCache.containsKey(component)) {
            return this.classLoaderCache.get(component);
        }
        Collection<FileObject> jarFiles = component.facet(DynamicClassLoadingFacet.class).jarFiles;
        URL[] classpath = new URL[jarFiles.size()];
        try {
            int i = 0;
            for (FileObject jar : jarFiles) {
                File localJar = this.resourceService.localFile(jar);
                classpath[i] = localJar.toURI().toURL();
                ++i;
            }
        }
        catch (MalformedURLException e) {
            throw new MetaborgRuntimeException(e);
        }
        logger.trace("Loading jar files {}", new Object[]{classpath});
        URLClassLoader classLoader = new URLClassLoader(classpath, (ClassLoader)new DynamicClassLoader(this.additionalClassLoaders));
        this.classLoaderCache.put(component, classLoader);
        return classLoader;
    }

    @Override
    public void invalidateCache(ILanguageComponent component) {
        this.serviceLoaderCache.remove(component);
        this.classLoaderCache.remove(component);
    }

    @Override
    public void invalidateCache(ILanguageImpl impl) {
        for (ILanguageComponent component : impl.components()) {
            this.invalidateCache(component);
        }
    }
}

