/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.analysis;

import jakarta.annotation.Nullable;
import org.metaborg.spoofax.core.analysis.AnalysisFacet;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class AnalysisFacetFromESV {
    public static boolean hasAnalysis(IStrategoAppl esv) {
        return ESVReader.findTerm(esv, "SemanticObserver") != null;
    }

    @Nullable
    public static AnalysisFacet create(IStrategoAppl esv) {
        String strategyName = AnalysisFacetFromESV.strategyName(esv);
        if (strategyName == null) {
            return null;
        }
        return new AnalysisFacet(strategyName);
    }

    @Nullable
    private static String strategyName(IStrategoAppl esv) {
        IStrategoAppl strategy = ESVReader.findTerm(esv, "SemanticObserver");
        if (strategy == null) {
            return null;
        }
        String observerFunction = ESVReader.termContents(strategy.getSubterm(0));
        return observerFunction;
    }

    @Nullable
    public static String type(IStrategoAppl esv) {
        IStrategoAppl strategy = ESVReader.findTerm(esv, "SemanticObserver");
        if (strategy == null) {
            return null;
        }
        IStrategoTerm annotations = strategy.getSubterm(1);
        boolean multifile = false;
        boolean constraint = false;
        for (IStrategoTerm annotation : annotations) {
            multifile |= TermUtils.isAppl(annotation, "MultiFile", 0);
            constraint |= TermUtils.isAppl(annotation, "Constraint", 0);
        }
        if (constraint) {
            return multifile ? "constraint-multifile" : "constraint-singlefile";
        }
        if (multifile) {
            return "taskengine";
        }
        return "stratego";
    }
}

