/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.deepconflicts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.GrammarFactory;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.IterStarSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSymbol;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.UniqueProduction;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.util.collection.BiMap2;
import org.metaborg.util.collection.SetMultimap;

public class DeepConflictsAnalyzer {
    private final ParseTable pt;
    private final boolean isContextMappingStable;
    private final Map<Integer, Integer> leftmostContextsMapping;
    private final Map<Integer, Integer> rightmostContextsMapping;
    private final Map<UniqueProduction, Production> uniqueProductionMapping;
    private final BiMap2<IProduction, ContextualProduction> prodContextualProdMapping;
    private final BiMap2<IProduction, Integer> productionLabels;
    private final SetMultimap<ISymbol, IProduction> symbolProductionsMapping;
    private final SetMultimap<IProduction, IAttribute> productionAttributesMapping;
    private final SetMultimap<Priority, Integer> priorities;

    public static DeepConflictsAnalyzer fromParseTable(ParseTable pt) {
        DeepConflictsAnalyzer phase1 = new DeepConflictsAnalyzer(pt);
        phase1.deepConflictAnalysis();
        HashSet<Integer> newLabels = new HashSet<Integer>(phase1.productionLabels.inverse().keySet());
        HashSet<Integer> oldLabels = new HashSet<Integer>(pt.productionLabels().inverse().keySet());
        HashSet<Integer> diffLabels = new HashSet<Integer>(newLabels);
        diffLabels.removeAll(oldLabels);
        diffLabels.forEach(pt.getProdLabelFactory()::releaseLabel);
        DeepConflictsAnalyzer phase2 = new DeepConflictsAnalyzer(pt, phase1.leftmostContextsMapping, phase1.rightmostContextsMapping);
        phase2.deepConflictAnalysis();
        return phase2;
    }

    private DeepConflictsAnalyzer(ParseTable pt) {
        this.pt = pt;
        this.isContextMappingStable = false;
        this.leftmostContextsMapping = new LinkedHashMap<Integer, Integer>();
        this.rightmostContextsMapping = new LinkedHashMap<Integer, Integer>();
        this.uniqueProductionMapping = new LinkedHashMap<UniqueProduction, Production>(pt.normalizedGrammar().getUniqueProductionMapping());
        this.prodContextualProdMapping = new BiMap2<IProduction, ContextualProduction>(pt.normalizedGrammar().getProdContextualProdMapping());
        this.productionLabels = new BiMap2<IProduction, Integer>(pt.productionLabels());
        this.symbolProductionsMapping = new SetMultimap<ISymbol, IProduction>(pt.normalizedGrammar().getSymbolProductionsMapping());
        this.productionAttributesMapping = new SetMultimap<IProduction, IAttribute>(pt.normalizedGrammar().getProductionAttributesMapping());
        this.priorities = new SetMultimap<Priority, Integer>(pt.normalizedGrammar().priorities());
    }

    private DeepConflictsAnalyzer(ParseTable pt, Map<Integer, Integer> leftmostContextsMapping, Map<Integer, Integer> rightmostContextsMapping) {
        this.pt = pt;
        this.isContextMappingStable = true;
        this.leftmostContextsMapping = Collections.unmodifiableMap(new LinkedHashMap<Integer, Integer>(leftmostContextsMapping));
        this.rightmostContextsMapping = Collections.unmodifiableMap(new LinkedHashMap<Integer, Integer>(rightmostContextsMapping));
        this.uniqueProductionMapping = new HashMap<UniqueProduction, Production>(pt.normalizedGrammar().getUniqueProductionMapping());
        this.prodContextualProdMapping = new BiMap2<IProduction, ContextualProduction>(pt.normalizedGrammar().getProdContextualProdMapping());
        this.productionLabels = new BiMap2<IProduction, Integer>(pt.productionLabels());
        this.symbolProductionsMapping = new SetMultimap<ISymbol, IProduction>(pt.normalizedGrammar().getSymbolProductionsMapping());
        this.productionAttributesMapping = new SetMultimap<IProduction, IAttribute>(pt.normalizedGrammar().getProductionAttributesMapping());
        this.priorities = new SetMultimap<Priority, Integer>(pt.normalizedGrammar().priorities());
    }

    public void patchParseTable() {
        this.pt.normalizedGrammar().getUniqueProductionMapping().putAll(this.uniqueProductionMapping);
        this.pt.normalizedGrammar().getSymbolProductionsMapping().putAll(this.symbolProductionsMapping);
        this.pt.productionLabels().putAll(this.productionLabels);
        this.pt.normalizedGrammar().getProductionAttributesMapping().putAll(this.productionAttributesMapping);
        this.pt.normalizedGrammar().getProdContextualProdMapping().putAll(this.prodContextualProdMapping);
        this.pt.normalizedGrammar().priorities().putAll(this.priorities);
        this.pt.getLeftmostContextsMapping().putAll(this.leftmostContextsMapping);
        this.pt.getRightmostContextsMapping().putAll(this.rightmostContextsMapping);
    }

    public void deepConflictAnalysis() {
        this.deepConflictAnalysis(this.pt, true, true, true);
    }

    public void deepConflictAnalysis(ParseTable pt, boolean operatorStyle, boolean danglingPrefixOrSuffix, boolean longestMatch) {
        this.fixNullableRecursive();
        for (Priority prio : pt.normalizedGrammar().priorities().keySet()) {
            Production higher = prio.higher();
            Production lower = prio.lower();
            if (operatorStyle) {
                if (higher.leftRecursivePosition() != -1 && lower.leftRecursivePosition() == -1 && lower.rightRecursivePosition() != -1 && this.mutuallyRecursive(pt, prio) && pt.normalizedGrammar().priorities().containsEntry(prio, 0)) {
                    this.handleInfixPrefixConflict(pt, prio, higher, lower);
                } else if (higher.rightRecursivePosition() != -1 && lower.leftRecursivePosition() != -1 && lower.rightRecursivePosition() == -1 && this.mutuallyRecursive(pt, prio) && pt.normalizedGrammar().priorities().containsEntry(prio, higher.getRhs().size() - 1)) {
                    this.handleInfixPostFixConflict(pt, prio, higher, lower);
                }
                this.handleIndirectRecursionConflict(pt, prio, higher);
            }
            if (!danglingPrefixOrSuffix) continue;
            if (!higher.equals(lower) && pt.getDanglingSuffix().contains(higher) && pt.getDanglingSuffix().contains(lower)) {
                this.handleDanglingSuffixConflict(pt, prio, higher, lower);
            }
            if (higher.equals(lower) || !pt.getDanglingPrefix().contains(higher) || !pt.getDanglingPrefix().contains(lower)) continue;
            this.handleDanglingPrefixConflict(pt, prio, higher, lower);
        }
        if (longestMatch) {
            for (Symbol s : pt.normalizedGrammar().getLongestMatchProdsFront().keySet()) {
                this.handleLongestMatchConflictFront(pt, s);
            }
            for (Symbol s : pt.normalizedGrammar().getLongestMatchProdsBack().keySet()) {
                this.handleLongestMatchConflictBack(pt, s);
            }
        }
    }

    private void fixNullableRecursive() {
    }

    private boolean mutuallyRecursive(ParseTable pt, Priority p) {
        return ((Set)pt.normalizedGrammar().getLeftRecursiveSymbolsMapping().get(p.higher().leftHand())).contains(p.lower().leftHand()) || ((Set)pt.normalizedGrammar().getRightRecursiveSymbolsMapping().get(p.higher().leftHand())).contains(p.lower().leftHand());
    }

    private Context deepContextFrom(int productionId, ContextPosition position) {
        if (this.isContextMappingStable) {
            return this.pt.getContextualFactory().createContext(productionId, ContextType.DEEP, position, this.leftmostContextsMapping, this.rightmostContextsMapping);
        }
        return this.pt.getContextualFactory().createContext(productionId, ContextType.DEEP, position, Collections.emptyMap(), Collections.emptyMap());
    }

    private Context danglingContextFrom(int productionId, ContextPosition position) {
        if (this.isContextMappingStable) {
            return this.pt.getContextualFactory().createContext(productionId, ContextType.DANGLING, position, this.leftmostContextsMapping, this.rightmostContextsMapping);
        }
        return this.pt.getContextualFactory().createContext(productionId, ContextType.DANGLING, position, Collections.emptyMap(), Collections.emptyMap());
    }

    private void handleInfixPrefixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Priority inverse = pt.normalizedGrammar().getGrammarFactory().createPriority(lower, higher, false);
        if (((Set)pt.normalizedGrammar().priorities().get(inverse)).contains(lower.rightRecursivePosition())) {
            return;
        }
        int conflict_pos = higher.leftRecursivePosition();
        HashSet<Context> contexts = new HashSet<Context>();
        int labelLower = this.productionLabels.get(prio.lower());
        if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelLower)) {
            this.rightmostContextsMapping.put(labelLower, this.rightmostContextsMapping.size());
        }
        Context new_context = this.deepContextFrom(labelLower, ContextPosition.RIGHTMOST);
        contexts.add(new_context);
        HashSet<Integer> conflicting_args = new HashSet<Integer>();
        conflicting_args.add(conflict_pos);
        ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)this.productionLabels.get(prio.higher()), pt.getContextualFactory());
        if (!this.prodContextualProdMapping.containsKey(prio.higher())) {
            this.prodContextualProdMapping.put(prio.higher(), p);
        } else {
            ContextualProduction existing_prod = this.prodContextualProdMapping.get(prio.higher());
            this.prodContextualProdMapping.replace(prio.higher(), existing_prod.addContext(new_context, conflicting_args));
        }
    }

    private void handleInfixPostFixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Priority inverse = pt.normalizedGrammar().getGrammarFactory().createPriority(lower, higher, false);
        if (((Set)pt.normalizedGrammar().priorities().get(inverse)).contains(0)) {
            return;
        }
        int conflict_pos = higher.rightRecursivePosition();
        HashSet<Context> contexts = new HashSet<Context>();
        int labelLower = this.productionLabels.get(prio.lower());
        if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelLower)) {
            this.leftmostContextsMapping.put(labelLower, this.leftmostContextsMapping.size());
        }
        Context new_context = this.deepContextFrom(labelLower, ContextPosition.LEFTMOST);
        contexts.add(new_context);
        HashSet<Integer> conflicting_args = new HashSet<Integer>();
        conflicting_args.add(conflict_pos);
        ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)this.productionLabels.get(prio.higher()), pt.getContextualFactory());
        if (!this.prodContextualProdMapping.containsKey(prio.higher())) {
            this.prodContextualProdMapping.put(prio.higher(), p);
        } else {
            ContextualProduction existing_prod = this.prodContextualProdMapping.get(prio.higher());
            this.prodContextualProdMapping.replace(prio.higher(), existing_prod.addContext(new_context, conflicting_args));
        }
    }

    private void handleDanglingSuffixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Iterator iterator = ((Set)pt.normalizedGrammar().priorities().get(prio)).iterator();
        while (iterator.hasNext()) {
            int conflict = (Integer)iterator.next();
            if (conflict < 0) continue;
            HashSet<Context> contexts = new HashSet<Context>();
            int labelLower = this.productionLabels.get(prio.lower());
            if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelLower)) {
                this.rightmostContextsMapping.put(labelLower, this.rightmostContextsMapping.size());
            }
            Context new_context_right = this.danglingContextFrom(labelLower, ContextPosition.RIGHTMOST);
            Context new_context_left = this.danglingContextFrom(labelLower, ContextPosition.LEFTMOST);
            contexts.add(new_context_right);
            contexts.add(new_context_left);
            HashSet<Integer> conflicting_args = new HashSet<Integer>();
            conflicting_args.add(conflict);
            ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)this.productionLabels.get(prio.higher()), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey(prio.higher())) {
                this.prodContextualProdMapping.put(prio.higher(), p);
                continue;
            }
            ContextualProduction existing_prod = this.prodContextualProdMapping.get(prio.higher());
            existing_prod = existing_prod.addContext(new_context_right, conflicting_args);
            this.prodContextualProdMapping.replace(prio.higher(), existing_prod.addContext(new_context_left, conflicting_args));
        }
    }

    private void handleDanglingPrefixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Iterator iterator = ((Set)pt.normalizedGrammar().priorities().get(prio)).iterator();
        while (iterator.hasNext()) {
            int conflict = (Integer)iterator.next();
            if (conflict < 0 || lower.getRhs().size() < higher.getRhs().size() - conflict) continue;
            HashSet<Context> contexts = new HashSet<Context>();
            int labelLower = this.productionLabels.get(prio.lower());
            if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelLower)) {
                this.leftmostContextsMapping.put(labelLower, this.leftmostContextsMapping.size());
            }
            Context new_context_right = this.danglingContextFrom(labelLower, ContextPosition.RIGHTMOST);
            Context new_context_left = this.danglingContextFrom(labelLower, ContextPosition.LEFTMOST);
            contexts.add(new_context_right);
            contexts.add(new_context_left);
            HashSet<Integer> conflicting_args = new HashSet<Integer>();
            conflicting_args.add(conflict);
            ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)this.productionLabels.get(prio.higher()), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey(prio.higher())) {
                this.prodContextualProdMapping.put(prio.higher(), p);
                continue;
            }
            ContextualProduction existing_prod = this.prodContextualProdMapping.get(prio.higher());
            existing_prod = existing_prod.addContext(new_context_right, conflicting_args);
            this.prodContextualProdMapping.replace(prio.higher(), existing_prod.addContext(new_context_left, conflicting_args));
        }
    }

    private void handleIndirectRecursionConflict(ParseTable pt, Priority prio, Production higher) {
        for (Integer arg : (Set)pt.normalizedGrammar().priorities().get(prio)) {
            ContextualProduction existing_prod;
            ContextualProduction p;
            Context new_context;
            int labelLower;
            HashSet<Context> contexts;
            HashSet<Integer> conflicting_args;
            if (arg < 0 || arg >= higher.getRhs().size()) continue;
            if (arg.intValue() == higher.leftRecursivePosition() && ((Set)pt.normalizedGrammar().getLeftRecursiveSymbolsMapping().get(higher.leftHand())).contains(higher.getRhs().get(arg)) && !higher.getRhs().get(arg).equals(prio.lower().leftHand())) {
                conflicting_args = new HashSet<Integer>();
                conflicting_args.add(arg);
                contexts = new HashSet<Context>();
                labelLower = this.productionLabels.get(prio.lower());
                new_context = this.deepContextFrom(labelLower, ContextPosition.RIGHTMOST);
                contexts.add(new_context);
                p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)this.productionLabels.get(prio.higher()), pt.getContextualFactory());
                if (!this.prodContextualProdMapping.containsKey(prio.higher())) {
                    this.prodContextualProdMapping.put(prio.higher(), p);
                } else {
                    existing_prod = this.prodContextualProdMapping.get(prio.higher());
                    this.prodContextualProdMapping.replace(prio.higher(), existing_prod.addContext(new_context, conflicting_args));
                }
            }
            if (arg.intValue() != higher.rightRecursivePosition() || !((Set)pt.normalizedGrammar().getRightRecursiveSymbolsMapping().get(higher.leftHand())).contains(higher.getRhs().get(arg)) || higher.getRhs().get(arg).equals(prio.lower().leftHand())) continue;
            conflicting_args = new HashSet();
            conflicting_args.add(arg);
            contexts = new HashSet();
            labelLower = this.productionLabels.get(prio.lower());
            if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelLower)) {
                this.leftmostContextsMapping.put(labelLower, this.leftmostContextsMapping.size());
            }
            new_context = this.deepContextFrom(labelLower, ContextPosition.LEFTMOST);
            contexts.add(new_context);
            p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)this.productionLabels.get(prio.higher()), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey(prio.higher())) {
                this.prodContextualProdMapping.put(prio.higher(), p);
                continue;
            }
            existing_prod = this.prodContextualProdMapping.get(prio.higher());
            this.prodContextualProdMapping.replace(prio.higher(), existing_prod.addContext(new_context, conflicting_args));
        }
    }

    private void handleLongestMatchConflictFront(ParseTable pt2, Symbol s) {
        HashSet<Context> contexts = new HashSet<Context>();
        GrammarFactory gf = this.pt.normalizedGrammar().getGrammarFactory();
        Set longestMatchProds = (Set)this.pt.normalizedGrammar().getLongestMatchProdsFront().get(s);
        for (Production p : longestMatchProds) {
            int labelP = this.productionLabels.get(p);
            if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelP)) {
                this.leftmostContextsMapping.put(labelP, this.leftmostContextsMapping.size());
            }
            Context new_context = this.deepContextFrom(labelP, ContextPosition.LEFTMOST);
            contexts.add(new_context);
        }
        Symbol iterList = s;
        if (s instanceof LexicalSymbol) {
            Symbol list = ((LexicalSymbol)s).getSymbol();
            if (list instanceof IterStarSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSymbol(((IterStarSymbol)list).getSymbol()));
            } else if (list instanceof IterStarSepSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSepSymbol(((IterStarSepSymbol)list).getSymbol(), ((IterStarSepSymbol)list).getSeparator()));
            }
        }
        for (IProduction p : (Set)this.symbolProductionsMapping.get(iterList)) {
            if (p.arity() <= 1) continue;
            ContextualProduction ctx_p = this.pt.getContextualFactory().createContextualProduction((Production)p, contexts, new HashSet<Integer>(Arrays.asList(2)), (int)this.productionLabels.get(p), this.pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey(p)) {
                this.prodContextualProdMapping.put(p, ctx_p);
                continue;
            }
            ContextualProduction existing_prod = this.prodContextualProdMapping.get(p);
            this.prodContextualProdMapping.replace(p, existing_prod.addContexts(contexts, new HashSet<Integer>(Arrays.asList(2))));
        }
    }

    private void handleLongestMatchConflictBack(ParseTable pt, Symbol s) {
        Set<Context> contexts = new HashSet<Context>();
        GrammarFactory gf = this.pt.normalizedGrammar().getGrammarFactory();
        Set longestMatchProds = (Set)pt.normalizedGrammar().getLongestMatchProdsBack().get(s);
        for (Production p : longestMatchProds) {
            int labelP = this.productionLabels.get(p);
            if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelP)) {
                this.rightmostContextsMapping.put(labelP, this.rightmostContextsMapping.size());
            }
            Context new_context = this.deepContextFrom(labelP, ContextPosition.RIGHTMOST);
            contexts.add(new_context);
        }
        Symbol iterList = s;
        LinkedHashMap<Production, Production> newProductions = new LinkedHashMap<Production, Production>();
        if (s instanceof ContextFreeSymbol) {
            Symbol list = ((ContextFreeSymbol)s).getSymbol();
            if (list instanceof IterStarSymbol) {
                int pos;
                iterList = gf.createContextFreeSymbol(gf.createIterSymbol(((IterStarSymbol)list).getSymbol()));
                for (Production p : (Set)pt.normalizedGrammar().getLongestMatchProdsBack().get(s)) {
                    if (p.getRhs().size() < 0) continue;
                    pos = p.getRhs().size() - 3;
                    ISymbol spos = p.getRhs().get(pos);
                    if (!((Set)pt.normalizedGrammar().getRightRecursiveSymbolsMapping().get(spos)).contains(p.leftHand())) continue;
                    IProduction nullableListProd = null;
                    IProduction nonNullableListProd = null;
                    for (IProduction list_p : (Set)this.symbolProductionsMapping.get(s)) {
                        if (list_p.arity() == 1) {
                            nonNullableListProd = list_p;
                            continue;
                        }
                        nullableListProd = list_p;
                    }
                    if (nullableListProd == null || nonNullableListProd == null) continue;
                    if (nonNullableListProd instanceof Production) {
                        this.priorities.put(gf.createPriority(p, (Production)nonNullableListProd, false), p.arity() - 1);
                    } else {
                        this.priorities.put(gf.createPriority(p, ((ContextualProduction)nonNullableListProd).getOrigProduction(), false), p.arity() - 1);
                    }
                    ArrayList<Symbol> new_rhs = new ArrayList<Symbol>();
                    int i = 0;
                    while (i < p.arity() - 1) {
                        new_rhs.add(p.getRhs().get(i));
                        ++i;
                    }
                    new_rhs.add(iterList);
                    Production newProd = gf.createProduction(p.getLhs(), new_rhs, p.leftRecursivePosition(), p.rightRecursivePosition());
                    UniqueProduction uniqueProd = gf.createUniqueProduction(p.getLhs(), new_rhs);
                    this.uniqueProductionMapping.put(uniqueProd, newProd);
                    this.productionAttributesMapping.putAll(newProd, (Collection<IAttribute>)this.productionAttributesMapping.get(p));
                    this.symbolProductionsMapping.put(p.leftHand(), newProd);
                    this.productionLabels.put(newProd, pt.getProdLabelFactory().getNextLabel());
                    int labelNewProd = this.productionLabels.get(newProd);
                    if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelNewProd)) {
                        this.rightmostContextsMapping.put(labelNewProd, this.rightmostContextsMapping.size());
                    }
                    Context new_context = this.deepContextFrom(labelNewProd, ContextPosition.RIGHTMOST);
                    contexts.add(new_context);
                    newProductions.put(newProd, p);
                }
                for (Production newProd : newProductions.keySet()) {
                    pos = ((Production)newProductions.get(newProd)).arity() - 3;
                    if (!this.prodContextualProdMapping.containsKey(newProd)) {
                        ContextualProduction ctx_p2 = pt.getContextualFactory().createContextualProduction(newProd, contexts, new HashSet<Integer>(Arrays.asList(pos)), (int)this.productionLabels.get(newProd), pt.getContextualFactory());
                        contexts = Collections.unmodifiableSet(contexts);
                        this.prodContextualProdMapping.put(newProd, ctx_p2);
                        continue;
                    }
                    ContextualProduction existing_prod = this.prodContextualProdMapping.get((IProduction)newProductions.get(newProd));
                    this.prodContextualProdMapping.replace(newProd, existing_prod.addContexts(contexts, new HashSet<Integer>(Arrays.asList(pos))));
                }
            } else if (list instanceof IterStarSepSymbol) {
                iterList = gf.createContextFreeSymbol(gf.createIterSepSymbol(((IterStarSepSymbol)list).getSymbol(), ((IterStarSepSymbol)list).getSeparator()));
            }
        }
        if (s instanceof LexicalSymbol) {
            Symbol list = ((LexicalSymbol)s).getSymbol();
            if (list instanceof IterStarSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSymbol(((IterStarSymbol)list).getSymbol()));
            } else if (list instanceof IterStarSepSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSepSymbol(((IterStarSepSymbol)list).getSymbol(), ((IterStarSepSymbol)list).getSeparator()));
            }
        }
        for (IProduction p : (Set)this.symbolProductionsMapping.get(iterList)) {
            if (p.arity() <= 1) continue;
            ContextualProduction ctx_p = pt.getContextualFactory().createContextualProduction((Production)p, contexts, new HashSet<Integer>(Arrays.asList(0)), (int)this.productionLabels.get(p), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey(p)) {
                this.prodContextualProdMapping.put(p, ctx_p);
                continue;
            }
            ContextualProduction existing_prod = this.prodContextualProdMapping.get(p);
            this.prodContextualProdMapping.replace(p, existing_prod.addContexts(contexts, new HashSet<Integer>(Arrays.asList(0))));
        }
    }
}

