/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.engine;

import java.util.HashSet;
import java.util.Set;
import org.metaborg.util.iterators.Iterables2;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class TaskCollection {
    private final Set<IStrategoTerm> addedTasks = new HashSet<IStrategoTerm>();
    private final Set<IStrategoTerm> removedTasks = new HashSet<IStrategoTerm>();
    private final Set<IStrategoTerm> inCollection = new HashSet<IStrategoTerm>();

    public void startCollection(IStrategoTerm source, Iterable<IStrategoTerm> tasksIDsInSource) {
        if (this.inCollection.contains(source)) {
            throw new IllegalStateException("Collection has already been started. Call task-stop-collection(|source) before starting a new collection.");
        }
        this.addedTasks.clear();
        this.removedTasks.clear();
        Iterables2.addAll(this.removedTasks, tasksIDsInSource);
        this.inCollection.add(source);
    }

    public boolean inCollection(IStrategoTerm source) {
        return this.inCollection.contains(source);
    }

    public void addTask(IStrategoTerm taskID) {
        this.addedTasks.add(taskID);
    }

    public void keepTask(IStrategoTerm taskID) {
        this.removedTasks.remove(taskID);
    }

    public Iterable<IStrategoTerm> stopCollection(IStrategoTerm source) {
        if (!this.inCollection(source)) {
            throw new IllegalStateException("Collection has not been started yet. Call task-start-collection(|source) before stopping collection.");
        }
        this.inCollection.remove(source);
        return this.removedTasks;
    }

    public Iterable<IStrategoTerm> addedTasks() {
        return this.addedTasks;
    }

    public void recover() {
        this.reset();
    }

    public void reset() {
        this.addedTasks.clear();
        this.removedTasks.clear();
        this.inCollection.clear();
    }
}

