/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.resource;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class ModifiedFileSelector
implements FileSelector {
    private final FileObject copyToLocation;

    public ModifiedFileSelector(FileObject copyToLocation) {
        this.copyToLocation = copyToLocation;
    }

    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        FileObject originalFile = fileInfo.getFile();
        if (!originalFile.isFile()) {
            return true;
        }
        FileObject copyToCandidate = this.copyToLocation.resolveFile(fileInfo.getBaseFolder().getName().getRelativeName(originalFile.getName()));
        return !copyToCandidate.exists() || copyToCandidate.getContent().getLastModifiedTime() <= originalFile.getContent().getLastModifiedTime();
    }

    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        return true;
    }
}

