/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.solver.IConstraint;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.tracer.EmptyTracer;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_solve_constraint_with_initial_state
extends StatixPrimitive {
    @Inject
    public STX_solve_constraint_with_initial_state() {
        super(STX_solve_constraint_with_initial_state.class.getSimpleName(), 4);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        SolverResult<EmptyTracer.Empty> resultConfig;
        IConstraint constraint = StatixTerms.constraint().match(term).orElseThrow(() -> new InterpreterException("Expected constraint, got " + term));
        SolverResult<?> solverResult = STX_solve_constraint_with_initial_state.getResult(terms.get(0));
        Spec spec = solverResult.spec();
        IDebugContext debug = this.getDebugContext(terms.get(1));
        IProgress progress = this.getProgress(terms.get(2));
        ICancel cancel = this.getCancel(terms.get(3));
        try {
            resultConfig = Solver.solve(spec, solverResult.state(), constraint, debug, cancel, progress, 0);
        }
        catch (InterruptedException e) {
            throw new InterpreterException(e);
        }
        IUniDisunifier.Immutable unifier = resultConfig.state().unifier();
        ArrayList<ITerm> substEntries = new ArrayList<ITerm>();
        for (Map.Entry e : resultConfig.existentials().entrySet()) {
            ITerm v = StatixTerms.explode((ITermVar)e.getKey());
            ITerm t = StatixTerms.explicateVars(unifier.findRecursive((ITerm)e.getValue()));
            substEntries.add(TermBuild.B.newTuple(v, t));
        }
        IListTerm substTerm = TermBuild.B.newList(substEntries);
        IBlobTerm solverTerm = TermBuild.B.newBlob(resultConfig);
        IApplTerm resultTerm = TermBuild.B.newAppl("Solution", substTerm, solverTerm);
        return Optional.of(resultTerm);
    }
}

