/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import java.util.ArrayList;
import java.util.Objects;
import mb.statix.constraints.CFalse;
import mb.statix.solver.persistent.step.ACFalseStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CFalseStep
extends ACFalseStep {
    private final CFalse constraint;
    private final StepResult result;
    private transient int hashCode;

    private CFalseStep(CFalse constraint, StepResult result) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
    }

    private CFalseStep(CFalseStep original, CFalse constraint, StepResult result) {
        this.constraint = constraint;
        this.result = result;
    }

    @Override
    public CFalse constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    public final CFalseStep withConstraint(CFalse value) {
        if (this.constraint == value) {
            return this;
        }
        CFalse newValue = Objects.requireNonNull(value, "constraint");
        return new CFalseStep(this, newValue, this.result);
    }

    public final CFalseStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CFalseStep(this, this.constraint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CFalseStep && this.equalTo(0, (CFalseStep)another);
    }

    private boolean equalTo(int synthetic, CFalseStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "CFalseStep{constraint=" + this.constraint + ", result=" + this.result + "}";
    }

    public static CFalseStep of(CFalse constraint, StepResult result) {
        return new CFalseStep(constraint, result);
    }

    public static CFalseStep copyOf(ACFalseStep instance) {
        if (instance instanceof CFalseStep) {
            return (CFalseStep)instance;
        }
        return CFalseStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CFalseStep(CFalseStep cFalseStep, CFalse cFalse, StepResult stepResult, CFalseStep cFalseStep2) {
        this(cFalseStep, cFalse, stepResult);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CFalse constraint;
        private StepResult result;

        private Builder() {
        }

        public final Builder from(ACFalseStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACFalseStep) {
                instance = (ACFalseStep)object;
                this.constraint(((ACFalseStep)instance).constraint());
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CFalse constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CFalseStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CFalseStep(null, this.constraint, this.result, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CFalseStep, some of required attributes are not set " + attributes;
        }
    }
}

