/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.esop15.reference.EsopScopeGraph;

public final class ScopeGraphCommon<S extends IScope, L extends ILabel, O extends IOccurrence, V> {
    private final IEsopScopeGraph<S, L, O, V> scopeGraph;

    public ScopeGraphCommon(IEsopScopeGraph<S, L, O, V> scopeGraph) {
        this.scopeGraph = scopeGraph;
    }

    public Set<O> reachingReferences(S scope) {
        return this.reachingScopes(scope).stream().flatMap(s -> this.scopeGraph.getRefs().inverse().get(s).stream()).collect(Collectors.toSet());
    }

    public Set<S> reachingScopes(S scope) {
        HashSet<IScope> reaches = new HashSet<IScope>(Arrays.asList(scope));
        ArrayDeque<IScope> worklist = new ArrayDeque<IScope>(Arrays.asList(scope));
        while (!worklist.isEmpty()) {
            IScope current = (IScope)worklist.pop();
            this.scopeGraph.getDirectEdges().inverse().get(current).stream().map(Map.Entry::getValue).filter(next -> !reaches.contains(next)).forEach(next -> {
                reaches.add((IScope)next);
                worklist.add((IScope)next);
            });
        }
        return reaches;
    }

    public Set<O> reachableDecls(S scope) {
        return this.reachableScopes(scope).stream().flatMap(s -> this.scopeGraph.getDecls().inverse().get(s).stream()).collect(Collectors.toSet());
    }

    public Set<S> reachableScopes(S scope) {
        HashSet<IScope> reachable = new HashSet<IScope>(Arrays.asList(scope));
        ArrayDeque<IScope> worklist = new ArrayDeque<IScope>(Arrays.asList(scope));
        while (!worklist.isEmpty()) {
            IScope current = (IScope)worklist.pop();
            this.scopeGraph.getDirectEdges().get(current).stream().map(Map.Entry::getValue).filter(next -> !reachable.contains(next)).forEach(next -> {
                reachable.add((IScope)next);
                worklist.add((IScope)next);
            });
        }
        return reachable;
    }

    public IEsopScopeGraph<S, L, O, V> summarize(S scope) {
        EsopScopeGraph.Transient summaryGraph = EsopScopeGraph.Transient.of();
        this.summarize((O)scope, (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, (Set<Object>)new HashSet<Object>());
        return summaryGraph.freeze();
    }

    private void summarize(S scope, IEsopScopeGraph.Transient<S, L, O, V> summaryGraph, Set<Object> visited) {
        if (!visited.contains(scope)) {
            visited.add(scope);
            for (IOccurrence iOccurrence : this.scopeGraph.getDecls().inverse().get(scope)) {
                summaryGraph.addDecl((IScope)scope, iOccurrence);
                this.summarize((O)iOccurrence, (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, visited);
            }
            for (Map.Entry entry : this.scopeGraph.getDirectEdges().get(scope)) {
                summaryGraph.addDirectEdge((IScope)scope, (ILabel)entry.getKey(), (IScope)entry.getValue());
                this.summarize((O)((IScope)entry.getValue()), (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, visited);
            }
        }
    }

    public IEsopScopeGraph<S, L, O, V> summarize(O decl) {
        EsopScopeGraph.Transient summaryGraph = EsopScopeGraph.Transient.of();
        this.summarize(decl, (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, (Set<Object>)new HashSet<Object>());
        return summaryGraph.freeze();
    }

    private void summarize(O decl, IEsopScopeGraph.Transient<S, L, O, V> summaryGraph, Set<Object> visited) {
        if (!visited.contains(decl)) {
            visited.add(decl);
            for (Map.Entry next : this.scopeGraph.getExportEdges().get(decl)) {
                summaryGraph.addExportEdge(decl, (ILabel)next.getKey(), (IScope)next.getValue());
                this.summarize((O)((IScope)next.getValue()), (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, visited);
            }
        }
    }
}

