/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.terms.path;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Objects;
import mb.scopegraph.oopsla20.path.IScopePath;
import mb.scopegraph.oopsla20.path.IStep;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.ConsList;
import org.metaborg.util.iterators.Iterators2;

@Value.Immutable
@Serial.Version(value=42L)
abstract class AComposedScopePath<S, L>
implements IScopePath<S, L> {
    AComposedScopePath() {
    }

    @Value.Parameter
    public abstract IScopePath<S, L> getLeft();

    @Value.Parameter
    public abstract IScopePath<S, L> getRight();

    @Nullable
    @Value.Check
    public AComposedScopePath<S, L> check() {
        if (!this.getLeft().getTarget().equals(this.getRight().getSource())) {
            return null;
        }
        if (this.scopeSet().size() < this.size()) {
            return null;
        }
        return this;
    }

    @Override
    @Value.Lazy
    public S getSource() {
        return this.getLeft().getSource();
    }

    @Override
    @Value.Lazy
    public S getTarget() {
        return this.getRight().getTarget();
    }

    @Override
    @Value.Lazy
    public int size() {
        return this.getLeft().size() + this.getRight().size();
    }

    @Override
    @Value.Lazy
    public ConsList<S> scopes() {
        return this.getLeft().scopes().append(this.getRight().scopes().tail());
    }

    @Override
    @Value.Lazy
    public Set.Immutable<S> scopeSet() {
        return this.getLeft().scopeSet().__insertAll(this.getRight().scopeSet());
    }

    @Override
    @Value.Lazy
    public ConsList<L> labels() {
        return this.getLeft().labels().append(this.getRight().labels());
    }

    @Override
    public Iterator<IStep<S, L>> iterator() {
        return Iterators2.fromConcat(this.getLeft().iterator(), this.getRight().iterator());
    }

    @Override
    public int hashCode() {
        return this.getLeft().hashCode() + BigInteger.valueOf(31L).pow(this.getLeft().size()).intValue() * this.getRight().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IScopePath)) {
            return false;
        }
        IScopePath other = (IScopePath)obj;
        if (!this.getSource().equals(other.getSource())) {
            return false;
        }
        if (!this.getTarget().equals(other.getTarget())) {
            return false;
        }
        Iterator<IStep<S, L>> iterator1 = this.iterator();
        Iterator iterator2 = other.iterator();
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            IStep<S, L> o1 = iterator1.next();
            if (Objects.equals(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    @Override
    public String toString(boolean includeSource, boolean includeTarget) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLeft().toString(includeSource, true));
        sb.append(" ");
        sb.append(this.getRight().toString(false, includeTarget));
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }
}

