/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.stamp.resource;

import java.io.IOException;
import java.util.Objects;
import mb.pie.api.stamp.ResourceStamper;
import mb.pie.api.stamp.resource.ByteArrayResourceStamp;
import mb.pie.api.stamp.resource.Hash;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HashWalkResourceStamper
implements ResourceStamper<HierarchicalResource> {
    private final @Nullable ResourceWalker walker;
    private final @Nullable ResourceMatcher matcher;

    public HashWalkResourceStamper(ResourceWalker walker, ResourceMatcher matcher) {
        this.walker = walker;
        this.matcher = matcher;
    }

    public HashWalkResourceStamper() {
        this.walker = null;
        this.matcher = null;
    }

    @Override
    public ByteArrayResourceStamp<HierarchicalResource> stamp(HierarchicalResource resource) throws IOException {
        Hash hasher = new Hash();
        hasher.updateRec(resource, this.walker, this.matcher);
        byte[] bytes = hasher.getHashBytesAndReset();
        return new ByteArrayResourceStamp<HierarchicalResource>(bytes, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashWalkResourceStamper that = (HashWalkResourceStamper)o;
        if (!Objects.equals(this.walker, that.walker)) {
            return false;
        }
        return Objects.equals(this.matcher, that.matcher);
    }

    public int hashCode() {
        int result = this.walker != null ? this.walker.hashCode() : 0;
        result = 31 * result + (this.matcher != null ? this.matcher.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HashWalkResourceStamper(" + this.walker + ", " + this.matcher + ")";
    }
}

