/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.AbstractUnit;
import mb.p_raffrayi.impl.IQueryAnswer;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.ScopeGraphLibraryWorker;
import mb.p_raffrayi.impl.StateSummary;
import mb.p_raffrayi.impl.confirm.ConfirmResult;
import mb.p_raffrayi.impl.diff.MatchingDiffer;
import mb.p_raffrayi.impl.tokens.Query;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.p_raffrayi.nameresolution.IQuery;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.library.IScopeGraphLibrary;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import mb.scopegraph.patching.PatchCollection;
import mb.scopegraph.patching.Patcher;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

class ScopeGraphLibraryUnit<S, L, D>
extends AbstractUnit<S, L, D, Unit> {
    private static final ILogger logger = LoggerUtils.logger(ScopeGraphLibraryUnit.class);
    private IScopeGraphLibrary<S, L, D> library;
    @Nullable
    private final IUnitResult<S, L, D, ?> previousResult;
    private final List<IActorRef<? extends IUnit<S, L, D, Unit>>> workers;

    ScopeGraphLibraryUnit(IActor<? extends IUnit<S, L, D, Unit>> self, @Nullable IActorRef<? extends IUnit<S, L, D, ?>> parent, IUnitContext<S, L, D> context, Iterable<L> edgeLabels, IScopeGraphLibrary<S, L, D> library, @Nullable IUnitResult<S, L, D, ?> previousResult) {
        super(self, parent, context, edgeLabels);
        this.library = library;
        this.workers = new ArrayList<IActorRef<? extends IUnit<S, L, D, Unit>>>();
        this.previousResult = previousResult;
    }

    protected void clearLibrary() {
        this.library = null;
    }

    @Override
    protected IFuture<D> getExternalDatum(D datum) {
        return CompletableFuture.completedFuture(datum);
    }

    @Override
    protected D getPreviousDatum(D datum) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public IFuture<IUnitResult<S, L, D, Unit>> _start(List<S> rootScopes) {
        this.doStart(rootScopes);
        if (this.previousResult == null) {
            this.buildScopeGraph(rootScopes);
        } else {
            this.restoreScopeGraph(rootScopes);
        }
        this.clearLibrary();
        if (this.isDifferEnabled() && this.previousResult != null) {
            this.initDiffer(new MatchingDiffer(this.differOps(), this.differContext(d -> d)), rootScopes, this.previousResult.rootScopes());
        }
        this.startWorkers();
        CompletableFuture<Unit> validationFinished = new CompletableFuture<Unit>();
        this.validateScopeGraph(validationFinished);
        return this.doFinish(validationFinished);
    }

    private void buildScopeGraph(List<S> rootScopes) {
        long t0 = System.currentTimeMillis();
        this.initRootScopes(rootScopes);
        Tuple2<Set<Object>, IScopeGraph.Immutable<Object, L, D>> libraryResult = this.library.initialize(rootScopes, this.context::makeScope);
        this.scopes.__insertAll(libraryResult._1());
        this.scopeGraph.set(libraryResult._2());
        this.closeRootScopes(rootScopes);
        long dt = System.currentTimeMillis() - t0;
        logger.info("Initialized {} in {} ms", this.self.id(), dt);
    }

    private void restoreScopeGraph(List<S> rootScopes) {
        this.initRootScopes(rootScopes);
        PatchCollection.Transient<S> patches = PatchCollection.Transient.of();
        Iterator<S> previousScopes = this.previousResult.rootScopes().iterator();
        for (S currentScope : rootScopes) {
            patches.put(currentScope, previousScopes.next());
        }
        if (patches.isIdentity()) {
            this.scopeGraph.set(this.previousResult.scopeGraph());
        } else {
            Patcher<Object, Object, Object> patcher = new Patcher.Builder().patchSources(patches).patchEdgeTargets(patches).patchDatumSources(patches).patchDatums(patches, this.context::substituteScopes).build();
            this.scopeGraph.set(patcher.apply(this.previousResult.scopeGraph(), (s, t) -> Unit.unit, (s_o, s_n, l, t_o, t_n, u) -> {}, Patcher.DataPatchCallback.noop()));
        }
        this.scopes.__insertAll(this.previousResult.scopes());
        this.closeRootScopes(rootScopes);
    }

    public void initRootScopes(List<S> rootScopes) {
        List edges = this.edgeLabels.stream().map(EdgeOrData::edge).collect(Collectors.toList());
        for (S rootScope : rootScopes) {
            this.doInitShare(this.self, rootScope, edges, false);
        }
    }

    public void closeRootScopes(List<S> rootScopes) {
        for (S rootScope : rootScopes) {
            for (Object label : this.edgeLabels) {
                EdgeOrData l = EdgeOrData.edge(label);
                for (S target : ((IScopeGraph.Immutable)this.scopeGraph.get()).getEdges(rootScope, label)) {
                    this.doAddEdge(this.self, rootScope, label, target);
                }
                this.doCloseLabel(this.self, rootScope, l);
            }
        }
    }

    private void startWorkers() {
        int i = 0;
        while (i < this.context.parallelism()) {
            Tuple2 worker = this.doAddSubUnit("worker-" + i, (subself, subcontext) -> new ScopeGraphLibraryWorker(subself, this.self, subcontext, this.edgeLabels, this.scopes, (IScopeGraph.Immutable)this.scopeGraph.get()), Collections.emptyList(), true);
            this.workers.add(worker._1());
            ++i;
        }
    }

    private void validateScopeGraph(ICompletableFuture<Unit> finished) {
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        future.thenApply(unit -> {
            HashSet invalidLabels = new HashSet();
            for (Object label : ((IScopeGraph.Immutable)this.scopeGraph.get()).getLabels()) {
                if (this.edgeLabels.contains(label)) continue;
                invalidLabels.add(label);
            }
            if (!invalidLabels.isEmpty()) {
                logger.warn("Scope graph library contains labels not in type checker specification: {}.", invalidLabels);
            }
            return Unit.unit;
        }).whenComplete(finished::complete);
        this.self.complete(future, Unit.unit, null);
    }

    @Override
    public void _initShare(S scope, Iterable<EdgeOrData<L>> edges, boolean sharing) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _addShare(S scope) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _doneSharing(S scope) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _addEdge(S source, L label, S target) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _closeEdge(S scope, EdgeOrData<L> edge) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public IFuture<IQueryAnswer<S, L, D>> _query(IActorRef<? extends IUnit<S, L, D, ?>> origin, ScopePath<S, L> path, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv) {
        ++this.stats.incomingQueries;
        IActorRef<? extends IUnit<S, L, D, Unit>> worker = this.workers.get(this.stats.incomingQueries % this.workers.size());
        IFuture<IQueryAnswer<S, L, D>> result = this.self.async(worker)._query(origin, path, query, dataWF, dataEquiv);
        Query<S, L, D> token = Query.of(this.self, path, query, dataWF, dataEquiv, result);
        this.waitFor(token, worker);
        return result.whenComplete((r, ex) -> {
            this.granted(token, worker);
            this.resume();
        });
    }

    @Override
    public IFuture<IQueryAnswer<S, L, D>> _queryPrevious(ScopePath<S, L> path, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv) {
        return this._query(this.self.sender(this.TYPE), path, query, dataWF, dataEquiv);
    }

    @Override
    public IFuture<ConfirmResult<S, L, D>> _confirm(S scope, LabelWf<L> labelWF, DataWf<S, L, D> dataWF, boolean prevEnvEmpty) {
        return CompletableFuture.completedFuture(ConfirmResult.confirm());
    }

    @Override
    public IFuture<Optional<S>> _match(S previousScope) {
        return CompletableFuture.completedFuture(Optional.of(previousScope));
    }

    @Override
    public IFuture<StateSummary<S, L, D>> _state() {
        return CompletableFuture.completedFuture(StateSummary.released(this.process, this.dependentSet()));
    }

    @Override
    public void _release() {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _restart() {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    public String toString() {
        return "StaticScopeGraphUnit{" + this.self.id() + "}";
    }
}

