/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.impl.AResult;
import mb.p_raffrayi.impl.StateCapture;
import mb.scopegraph.oopsla20.IScopeGraph;

public final class Result<S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>>
extends AResult<S, L, D, A, T>
implements Serializable {
    @Nullable
    private final A analysis;
    @Nullable
    private final StateCapture<S, L, D, T> localState;
    @Nullable
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    @Nullable
    private final Set<S> sharedScopes;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private Result(@Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable Iterable<? extends S> sharedScopes) {
        this.analysis = analysis;
        this.localState = localState;
        this.scopeGraph = scopeGraph;
        this.sharedScopes = sharedScopes == null ? null : Result.createUnmodifiableSet(Result.createSafeList(sharedScopes, true, false));
    }

    private Result(Result<S, L, D, A, T> original, @Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable Set<S> sharedScopes) {
        this.analysis = analysis;
        this.localState = localState;
        this.scopeGraph = scopeGraph;
        this.sharedScopes = sharedScopes;
    }

    @Override
    @Nullable
    public A analysis() {
        return this.analysis;
    }

    @Override
    @Nullable
    public StateCapture<S, L, D, T> localState() {
        return this.localState;
    }

    @Override
    @Nullable
    public IScopeGraph.Immutable<S, L, D> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    @Nullable
    public Set<S> sharedScopes() {
        return this.sharedScopes;
    }

    public final Result<S, L, D, A, T> withAnalysis(@Nullable A value) {
        if (this.analysis == value) {
            return this;
        }
        return new Result<S, L, D, A, T>(this, value, this.localState, this.scopeGraph, this.sharedScopes);
    }

    public final Result<S, L, D, A, T> withLocalState(@Nullable StateCapture<S, L, D, T> value) {
        if (this.localState == value) {
            return this;
        }
        return new Result<S, L, D, A, T>(this, this.analysis, value, this.scopeGraph, this.sharedScopes);
    }

    public final Result<S, L, D, A, T> withScopeGraph(@Nullable IScopeGraph.Immutable<S, L, D> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        return new Result<S, L, D, A, T>(this, this.analysis, this.localState, value, this.sharedScopes);
    }

    @SafeVarargs
    public final Result<S, L, D, A, T> withSharedScopes(S ... elements) {
        if (elements == null) {
            return new Result<S, L, D, A, T>(this, this.analysis, this.localState, this.scopeGraph, null);
        }
        Set<S> newValue = Arrays.asList(elements) == null ? null : Result.createUnmodifiableSet(Result.createSafeList(Arrays.asList(elements), true, false));
        return new Result<S, L, D, A, T>(this, this.analysis, this.localState, this.scopeGraph, newValue);
    }

    public final Result<S, L, D, A, T> withSharedScopes(@Nullable Iterable<? extends S> elements) {
        if (this.sharedScopes == elements) {
            return this;
        }
        Set<S> newValue = elements == null ? null : Result.createUnmodifiableSet(Result.createSafeList(elements, true, false));
        return new Result<S, L, D, A, T>(this, this.analysis, this.localState, this.scopeGraph, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Result && this.equalTo(0, (Result)another);
    }

    private boolean equalTo(int synthetic, Result<?, ?, ?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.analysis, another.analysis) && Objects.equals(this.localState, another.localState) && Objects.equals(this.scopeGraph, another.scopeGraph) && Objects.equals(this.sharedScopes, another.sharedScopes);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.analysis);
        h += (h << 5) + Objects.hashCode(this.localState);
        h += (h << 5) + Objects.hashCode(this.scopeGraph);
        h += (h << 5) + Objects.hashCode(this.sharedScopes);
        return h;
    }

    public String toString() {
        return "Result{analysis=" + this.analysis + ", localState=" + this.localState + ", scopeGraph=" + this.scopeGraph + ", sharedScopes=" + this.sharedScopes + "}";
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Result<S, L, D, A, T> of(@Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable Set<S> sharedScopes) {
        return Result.of(analysis, localState, scopeGraph, sharedScopes);
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Result<S, L, D, A, T> of(@Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable Iterable<? extends S> sharedScopes) {
        return new Result<S, L, D, A, T>(analysis, localState, scopeGraph, sharedScopes);
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Result<S, L, D, A, T> copyOf(AResult<S, L, D, A, T> instance) {
        if (instance instanceof Result) {
            return (Result)instance;
        }
        return Result.builder().from(instance).build();
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Builder<S, L, D, A, T> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    /* synthetic */ Result(Result result, ITypeChecker.IOutput iOutput, StateCapture stateCapture, IScopeGraph.Immutable immutable, Set set, Result result2) {
        this(result, iOutput, stateCapture, immutable, set);
    }

    public static final class Builder<S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> {
        private A analysis;
        private StateCapture<S, L, D, T> localState;
        private IScopeGraph.Immutable<S, L, D> scopeGraph;
        private List<S> sharedScopes = null;

        private Builder() {
        }

        public final Builder<S, L, D, A, T> from(AResult<S, L, D, A, T> instance) {
            Set<S> sharedScopesValue;
            IScopeGraph.Immutable<S, L, D> scopeGraphValue;
            StateCapture<S, L, D, T> localStateValue;
            Objects.requireNonNull(instance, "instance");
            A analysisValue = instance.analysis();
            if (analysisValue != null) {
                this.analysis(analysisValue);
            }
            if ((localStateValue = instance.localState()) != null) {
                this.localState(localStateValue);
            }
            if ((scopeGraphValue = instance.scopeGraph()) != null) {
                this.scopeGraph(scopeGraphValue);
            }
            if ((sharedScopesValue = instance.sharedScopes()) != null) {
                this.addAllSharedScopes(sharedScopesValue);
            }
            return this;
        }

        public final Builder<S, L, D, A, T> analysis(@Nullable A analysis) {
            this.analysis = analysis;
            return this;
        }

        public final Builder<S, L, D, A, T> localState(@Nullable StateCapture<S, L, D, T> localState) {
            this.localState = localState;
            return this;
        }

        public final Builder<S, L, D, A, T> scopeGraph(@Nullable IScopeGraph.Immutable<S, L, D> scopeGraph) {
            this.scopeGraph = scopeGraph;
            return this;
        }

        public final Builder<S, L, D, A, T> addSharedScopes(S element) {
            if (this.sharedScopes == null) {
                this.sharedScopes = new ArrayList<S>();
            }
            this.sharedScopes.add(Objects.requireNonNull(element, "sharedScopes element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, A, T> addSharedScopes(S ... elements) {
            if (this.sharedScopes == null) {
                this.sharedScopes = new ArrayList<S>();
            }
            S[] SArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                S element = SArray[n2];
                this.sharedScopes.add(Objects.requireNonNull(element, "sharedScopes element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D, A, T> sharedScopes(@Nullable Iterable<? extends S> elements) {
            if (elements == null) {
                this.sharedScopes = null;
                return this;
            }
            this.sharedScopes = new ArrayList<S>();
            return this.addAllSharedScopes(elements);
        }

        public final Builder<S, L, D, A, T> addAllSharedScopes(Iterable<? extends S> elements) {
            Objects.requireNonNull(elements, "sharedScopes element");
            if (this.sharedScopes == null) {
                this.sharedScopes = new ArrayList<S>();
            }
            for (S element : elements) {
                this.sharedScopes.add(Objects.requireNonNull(element, "sharedScopes element"));
            }
            return this;
        }

        public Result<S, L, D, A, T> build() {
            return new Result(null, (ITypeChecker.IOutput)this.analysis, this.localState, this.scopeGraph, this.sharedScopes == null ? null : Result.createUnmodifiableSet(this.sharedScopes), null);
        }
    }
}

