/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import io.usethesource.capsule.Set;
import java.util.Optional;
import java.util.Set;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.impl.RecordedQuery;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import mb.scopegraph.patching.IPatchCollection;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.CapsuleUtil;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ARecordedQuery<S, L, D>
implements IRecordedQuery<S, L, D> {
    @Override
    @Value.Parameter
    public abstract S source();

    @Override
    @Value.Parameter
    public abstract Set<S> datumScopes();

    @Override
    @Value.Parameter
    public abstract LabelWf<L> labelWf();

    @Override
    @Value.Parameter
    public abstract DataWf<S, L, D> dataWf();

    @Override
    @Value.Parameter
    public abstract boolean empty();

    @Override
    @Value.Parameter
    public abstract boolean includePatches();

    public static <S, L, D> RecordedQuery<S, L, D> of(ScopePath<S, L> scopePath, Set<S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, Env<S, L, D> result, boolean predicate) {
        return RecordedQuery.of(scopePath.getTarget(), datumScopes, labelWf, dataWf, result.isEmpty(), predicate);
    }

    public static <S, L, D> RecordedQuery<S, L, D> of(ScopePath<S, L> path, Set<S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, Env<S, L, D> result) {
        return ARecordedQuery.of(path, datumScopes, labelWf, dataWf, result, true);
    }

    public static <S, L, D> RecordedQuery<S, L, D> of(S scope, Set<S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, Env<S, L, D> result) {
        return RecordedQuery.of(scope, datumScopes, labelWf, dataWf, result);
    }

    public static <S, L, D> RecordedQuery<S, L, D> of(ScopePath<S, L> path, Set<S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf) {
        return RecordedQuery.of(path.getTarget(), datumScopes, labelWf, dataWf, false, true);
    }

    @Override
    public IRecordedQuery<S, L, D> patch(IPatchCollection.Immutable<S> patches) {
        if (patches.isIdentity()) {
            return this;
        }
        Optional<RecordedQuery.Builder<S, L, D>> builder = this.patchSource(patches);
        builder = this.patchDatumScopes(patches, builder);
        if ((builder = this.patchDataWf(patches, builder)).isPresent()) {
            return builder.get().build();
        }
        return this;
    }

    private Optional<RecordedQuery.Builder<S, L, D>> patchDataWf(IPatchCollection.Immutable<S> patches, Optional<RecordedQuery.Builder<S, L, D>> builder) {
        DataWf<S, L, D> newDataWf;
        DataWf<S, L, D> oldDataWf = this.dataWf();
        return oldDataWf == (newDataWf = oldDataWf.patch(patches)) ? builder : Optional.of(builder.orElseGet(() -> RecordedQuery.builder().from(this)).dataWf(newDataWf));
    }

    private Optional<RecordedQuery.Builder<S, L, D>> patchDatumScopes(IPatchCollection.Immutable<S> patches, Optional<RecordedQuery.Builder<S, L, D>> builder) {
        if (this.hasOverlap(this.datumScopes(), patches.patchDomain())) {
            Set.Transient newScopes = CapsuleUtil.transientSet();
            for (S scope : this.datumScopes()) {
                newScopes.__insert(patches.patch(scope));
            }
            return Optional.of(builder.orElseGet(() -> RecordedQuery.builder().from(this)).datumScopes(newScopes.freeze()));
        }
        return builder;
    }

    private Optional<RecordedQuery.Builder<S, L, D>> patchSource(IPatchCollection.Immutable<S> patches) {
        S newSource = patches.patch(this.source());
        if (newSource != this.source()) {
            return Optional.of(RecordedQuery.builder().from(this).source(newSource));
        }
        return Optional.empty();
    }

    private boolean hasOverlap(Set<S> set1, Set<S> set2) {
        Set<S> larger;
        Set<S> smaller;
        if (set2.size() < set1.size()) {
            smaller = set2;
            larger = set1;
        } else {
            smaller = set1;
            larger = set2;
        }
        for (S scope : smaller) {
            if (!larger.contains(scope)) continue;
            return true;
        }
        return false;
    }
}

