/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.analysis.ASingleUnitResult;
import mb.nabl2.terms.ITerm;

public final class SingleUnitResult
extends ASingleUnitResult
implements Serializable {
    private final List<IConstraint> constraints;
    private final ISolution solution;
    private final ITerm customAnalysis;
    private final Fresh.Immutable fresh;
    private static final long serialVersionUID = 42L;

    private SingleUnitResult(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Fresh.Immutable fresh) {
        this.constraints = SingleUnitResult.createUnmodifiableList(false, SingleUnitResult.createSafeList(constraints, true, false));
        this.solution = Objects.requireNonNull(solution, "solution");
        this.customAnalysis = customAnalysis.orElse(null);
        this.fresh = Objects.requireNonNull(fresh, "fresh");
    }

    private SingleUnitResult(SingleUnitResult original, List<IConstraint> constraints, ISolution solution, ITerm customAnalysis, Fresh.Immutable fresh) {
        this.constraints = constraints;
        this.solution = solution;
        this.customAnalysis = customAnalysis;
        this.fresh = fresh;
    }

    @Override
    public List<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    public ISolution solution() {
        return this.solution;
    }

    @Override
    public Optional<ITerm> customAnalysis() {
        return Optional.ofNullable(this.customAnalysis);
    }

    @Override
    public Fresh.Immutable fresh() {
        return this.fresh;
    }

    public final SingleUnitResult withConstraints(IConstraint ... elements) {
        List<IConstraint> newValue = SingleUnitResult.createUnmodifiableList(false, SingleUnitResult.createSafeList(Arrays.asList(elements), true, false));
        return new SingleUnitResult(this, newValue, this.solution, this.customAnalysis, this.fresh);
    }

    public final SingleUnitResult withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        List<IConstraint> newValue = SingleUnitResult.createUnmodifiableList(false, SingleUnitResult.createSafeList(elements, true, false));
        return new SingleUnitResult(this, newValue, this.solution, this.customAnalysis, this.fresh);
    }

    @Override
    public final SingleUnitResult withSolution(ISolution value) {
        if (this.solution == value) {
            return this;
        }
        ISolution newValue = Objects.requireNonNull(value, "solution");
        return new SingleUnitResult(this, this.constraints, newValue, this.customAnalysis, this.fresh);
    }

    @Override
    public final SingleUnitResult withCustomAnalysis(ITerm value) {
        ITerm newValue = Objects.requireNonNull(value, "customAnalysis");
        if (this.customAnalysis == newValue) {
            return this;
        }
        return new SingleUnitResult(this, this.constraints, this.solution, newValue, this.fresh);
    }

    public final SingleUnitResult withCustomAnalysis(Optional<? extends ITerm> optional) {
        ITerm value = optional.orElse(null);
        if (this.customAnalysis == value) {
            return this;
        }
        return new SingleUnitResult(this, this.constraints, this.solution, value, this.fresh);
    }

    @Override
    public final SingleUnitResult withFresh(Fresh.Immutable value) {
        if (this.fresh == value) {
            return this;
        }
        Fresh.Immutable newValue = Objects.requireNonNull(value, "fresh");
        return new SingleUnitResult(this, this.constraints, this.solution, this.customAnalysis, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SingleUnitResult && this.equalTo(0, (SingleUnitResult)another);
    }

    private boolean equalTo(int synthetic, SingleUnitResult another) {
        return this.constraints.equals(another.constraints) && this.solution.equals(another.solution) && Objects.equals(this.customAnalysis, another.customAnalysis) && this.fresh.equals(another.fresh);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.solution.hashCode();
        h += (h << 5) + Objects.hashCode(this.customAnalysis);
        h += (h << 5) + this.fresh.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SingleUnitResult{");
        builder.append("constraints=").append(this.constraints);
        builder.append(", ");
        builder.append("solution=").append(this.solution);
        if (this.customAnalysis != null) {
            builder.append(", ");
            builder.append("customAnalysis=").append(this.customAnalysis);
        }
        builder.append(", ");
        builder.append("fresh=").append(this.fresh);
        return builder.append("}").toString();
    }

    public static SingleUnitResult of(List<IConstraint> constraints, ISolution solution, Optional<ITerm> customAnalysis, Fresh.Immutable fresh) {
        return SingleUnitResult.of(constraints, solution, customAnalysis, fresh);
    }

    public static SingleUnitResult of(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Fresh.Immutable fresh) {
        return new SingleUnitResult(constraints, solution, customAnalysis, fresh);
    }

    public static SingleUnitResult copyOf(ASingleUnitResult instance) {
        if (instance instanceof SingleUnitResult) {
            return (SingleUnitResult)instance;
        }
        return SingleUnitResult.of(instance.constraints(), instance.solution(), instance.customAnalysis(), instance.fresh());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

