/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.solvers;

import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import mb.nabl2.config.NaBL2DebugConfig;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.ISolver;
import mb.nabl2.solver.SeedResult;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.components.AstComponent;
import mb.nabl2.solver.components.BaseComponent;
import mb.nabl2.solver.components.EqualityComponent;
import mb.nabl2.solver.components.ExternalRelationComponent;
import mb.nabl2.solver.components.ScopeGraphComponent;
import mb.nabl2.solver.exceptions.SolverException;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.solvers.BaseSolution;
import mb.nabl2.solver.solvers.CallExternal;
import mb.nabl2.solver.solvers.FixedPointSolver;
import mb.nabl2.solver.solvers.GraphSolution;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IProperties;
import mb.nabl2.util.collections.Properties;
import mb.scopegraph.pepm16.ScopeGraphReducer;
import mb.scopegraph.pepm16.esop15.CriticalEdge;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.esop15.reference.EsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.Ref;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class BaseSolver {
    protected final NaBL2DebugConfig nabl2Debug;
    protected final CallExternal callExternal;

    public BaseSolver(NaBL2DebugConfig nabl2Debug, CallExternal callExternal) {
        this.nabl2Debug = nabl2Debug;
        this.callExternal = callExternal;
    }

    public GraphSolution solveGraph(BaseSolution initial, Function1<String, String> fresh, ICancel cancel, IProgress progress) throws SolverException, InterruptedException {
        Ref<IUnifier.Immutable> unifier = new Ref<IUnifier.Immutable>(initial.unifier());
        EsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph = EsopScopeGraph.Transient.of();
        ScopeGraphReducer scopeGraphReducer = new ScopeGraphReducer(scopeGraph, unifier);
        SolverCore core = new SolverCore(initial.config(), unifier, fresh, this.callExternal, cancel, progress);
        AstComponent astSolver = new AstComponent(core, Properties.Transient.of());
        BaseComponent baseSolver = new BaseComponent(core);
        EqualityComponent equalitySolver = new EqualityComponent(core, unifier);
        ScopeGraphComponent scopeGraphSolver = new ScopeGraphComponent(core, scopeGraph);
        ExternalRelationComponent relationSolver = new ExternalRelationComponent(core);
        try {
            ISolver component = c -> c.matchOrThrow(IConstraint.CheckedCases.builder().onAst(astSolver::solve).onBase(baseSolver::solve).onEquality(equalitySolver::solve).onScopeGraph(scopeGraphSolver::solve).onRelation(relationSolver::solve).otherwise(ISolver.defer()));
            FixedPointSolver solver = new FixedPointSolver(cancel, progress, component);
            solver.step().subscribe(r -> {
                Set.Immutable<ITermVar> vars = r.result.unifierDiff().domainSet();
                if (!vars.isEmpty()) {
                    try {
                        List<CriticalEdge> criticalEdges = scopeGraphReducer.update((Iterable<? extends ITerm>)vars);
                        r.resolveCriticalEdges(criticalEdges);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            scopeGraphReducer.updateAll();
            SolveResult solveResult = solver.solve((Collection<? extends IConstraint>)initial.constraints(), unifier);
            GraphSolution solution = GraphSolution.of(initial.config(), astSolver.finish(), scopeGraphSolver.finish(), equalitySolver.finish(), solveResult.messages(), solveResult.constraints());
            return solution;
        }
        catch (RuntimeException ex) {
            throw new SolverException("Internal solver error.", ex);
        }
    }

    protected boolean seed(SeedResult result, IMessages.Transient messages, Set<IConstraint> constraints) {
        boolean change = false;
        change |= messages.addAll(result.messages());
        return change |= constraints.addAll((Collection<IConstraint>)result.constraints());
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    public static abstract class ABaseSolution {
        @Value.Parameter
        public abstract SolverConfig config();

        @Value.Parameter
        public abstract Set.Immutable<IConstraint> constraints();

        @Value.Parameter
        public abstract IUnifier.Immutable unifier();
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    public static abstract class AGraphSolution {
        @Value.Parameter
        public abstract SolverConfig config();

        @Value.Parameter
        public abstract IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties();

        @Value.Parameter
        public abstract IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph();

        @Value.Parameter
        public abstract IUnifier.Immutable unifier();

        @Value.Parameter
        public abstract IMessages.Immutable messages();

        @Value.Parameter
        public abstract Set.Immutable<IConstraint> constraints();
    }
}

