/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import java.util.Objects;
import mb.nabl2.relations.terms.VariantMatchers;
import mb.nabl2.relations.variants.IVariance;
import mb.nabl2.terms.ITerm;

final class Arg
extends VariantMatchers.AArg {
    private final IVariance variance;
    private final ITerm value;
    private static final long serialVersionUID = 42L;

    private Arg(IVariance variance, ITerm value) {
        this.variance = Objects.requireNonNull(variance, "variance");
        this.value = Objects.requireNonNull(value, "value");
    }

    private Arg(Arg original, IVariance variance, ITerm value) {
        this.variance = variance;
        this.value = value;
    }

    @Override
    public IVariance getVariance() {
        return this.variance;
    }

    @Override
    public ITerm getValue() {
        return this.value;
    }

    public final Arg withVariance(IVariance value) {
        if (this.variance == value) {
            return this;
        }
        IVariance newValue = Objects.requireNonNull(value, "variance");
        return new Arg(this, newValue, this.value);
    }

    public final Arg withValue(ITerm value) {
        if (this.value == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "value");
        return new Arg(this, this.variance, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Arg && this.equalTo(0, (Arg)another);
    }

    private boolean equalTo(int synthetic, Arg another) {
        return this.variance.equals(another.variance) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.variance.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "Arg{variance=" + this.variance + ", value=" + this.value + "}";
    }

    public static Arg of(IVariance variance, ITerm value) {
        return new Arg(variance, value);
    }

    public static Arg copyOf(VariantMatchers.AArg instance) {
        if (instance instanceof Arg) {
            return (Arg)instance;
        }
        return Arg.of(instance.getVariance(), instance.getValue());
    }
}

