/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.NegNode;

@GeneratedBy(value=NegNode.class)
public final class NegNodeGen
extends NegNode {
    @Node.Child
    private ExpressionNode number_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private NegNodeGen(ExpressionNode number) {
        this.number_ = number;
    }

    @Override
    public int executeInt(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && state != 0) {
            return this.executeInt_int0(frameValue, state);
        }
        return this.executeInt_generic1(frameValue, state);
    }

    private int executeInt_int0(VirtualFrame frameValue, int state) {
        int numberValue_;
        try {
            numberValue_ = this.number_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.negate(numberValue_);
    }

    private int executeInt_generic1(VirtualFrame frameValue, int state) {
        Object numberValue_ = this.number_.executeGeneric(frameValue);
        if ((state & 1) != 0 && numberValue_ instanceof Integer) {
            int numberValue__ = (Integer)numberValue_;
            return this.negate(numberValue__);
        }
        if ((state & 2) != 0) {
            return this.negate(numberValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(numberValue_);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        return this.executeInt(frameValue);
    }

    private int executeAndSpecialize(Object numberValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (numberValue instanceof Integer) {
                int numberValue_ = (Integer)numberValue;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.negate(numberValue_);
                return n;
            }
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            int n = this.negate(numberValue);
            return n;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static NegNode create(ExpressionNode number) {
        return new NegNodeGen(number);
    }
}

