/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import io.usethesource.capsule.Map;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.values.IMap;
import mb.flowspec.runtime.interpreter.values.Map;
import org.metaborg.util.collection.CapsuleUtil;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.terms.util.M;

public class MapLiteralNode
extends ExpressionNode {
    private final ExpressionNode[] values;

    public MapLiteralNode(ExpressionNode[] values) {
        this.values = values;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        return this.executeIMap(frame);
    }

    @Override
    public IMap<IStrategoTerm, IStrategoTerm> executeIMap(VirtualFrame frame) {
        Map.Transient map = CapsuleUtil.transientMap();
        ExpressionNode[] expressionNodeArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionNode expr = expressionNodeArray[n2];
            try {
                IStrategoTuple tuple = M.tuple(expr.executeIStrategoTerm(frame), 2);
                map.__put((Object)M.at(tuple, 0), (Object)M.at(tuple, 1));
            }
            catch (UnexpectedResultException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return new Map<IStrategoTerm, IStrategoTerm>(map.freeze());
    }
}

