/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import io.usethesource.capsule.BinaryRelation;
import io.usethesource.capsule.Set;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mb.flowspec.controlflow.BasicBlock;
import mb.flowspec.controlflow.ControlFlowGraph;
import mb.flowspec.controlflow.IBasicBlock;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.IControlFlowGraph;

public class ControlFlowGraphBuilder {
    private final BinaryRelation.Transient<ICFGNode, ICFGNode> edges;
    private final Set<ICFGNode> startNodes;
    private final Set<ICFGNode> normalNodes;
    private final Set<ICFGNode> endNodes;
    private final Set<ICFGNode> entryNodes;
    private final Set<ICFGNode> exitNodes;

    private ControlFlowGraphBuilder(BinaryRelation.Transient<ICFGNode, ICFGNode> edges, Set<ICFGNode> startNodes, Set<ICFGNode> normalNodes, Set<ICFGNode> endNodes, Set<ICFGNode> entryNodes, Set<ICFGNode> exitNodes) {
        this.edges = edges;
        this.startNodes = startNodes;
        this.normalNodes = normalNodes;
        this.endNodes = endNodes;
        this.entryNodes = entryNodes;
        this.exitNodes = exitNodes;
    }

    public BinaryRelation.Transient<ICFGNode, ICFGNode> edges() {
        return this.edges;
    }

    public Set<ICFGNode> startNodes() {
        return this.startNodes;
    }

    public Set<ICFGNode> normalNodes() {
        return this.normalNodes;
    }

    public Set<ICFGNode> endNodes() {
        return this.endNodes;
    }

    public Set<ICFGNode> entryNodes() {
        return this.entryNodes;
    }

    public Set<ICFGNode> exitNodes() {
        return this.exitNodes;
    }

    public static ControlFlowGraphBuilder of() {
        return new ControlFlowGraphBuilder((BinaryRelation.Transient<ICFGNode, ICFGNode>)BinaryRelation.Transient.of(), new HashSet<ICFGNode>(), new HashSet<ICFGNode>(), new HashSet<ICFGNode>(), new HashSet<ICFGNode>(), new HashSet<ICFGNode>());
    }

    public IControlFlowGraph build() {
        Set<ICFGNode> normalNodes = Collections.unmodifiableSet(this.normalNodes());
        Set<ICFGNode> startNodes = Collections.unmodifiableSet(this.startNodes());
        Set<ICFGNode> endNodes = Collections.unmodifiableSet(this.endNodes());
        Set<ICFGNode> entryNodes = Collections.unmodifiableSet(this.entryNodes());
        Set<ICFGNode> exitNodes = Collections.unmodifiableSet(this.exitNodes());
        BinaryRelation.Immutable edges = this.edges().freeze();
        HashSet<IBasicBlock> startBlocks = new HashSet<IBasicBlock>();
        HashSet<IBasicBlock> endBlocks = new HashSet<IBasicBlock>();
        BinaryRelation.Transient blockEdges = BinaryRelation.Transient.of();
        for (ICFGNode start : startNodes) {
            startBlocks.add(ControlFlowGraphBuilder.buildBlock(start, (BinaryRelation.Immutable<ICFGNode, ICFGNode>)edges, (BinaryRelation.Transient<IBasicBlock, IBasicBlock>)blockEdges, endBlocks));
        }
        return ControlFlowGraph.of((BinaryRelation.Immutable<ICFGNode, ICFGNode>)edges, (BinaryRelation.Immutable<IBasicBlock, IBasicBlock>)blockEdges.freeze(), Collections.unmodifiableSet(startBlocks), Collections.unmodifiableSet(endBlocks), startNodes, endNodes, entryNodes, exitNodes, normalNodes);
    }

    private static IBasicBlock buildBlock(ICFGNode startNode, BinaryRelation.Immutable<ICFGNode, ICFGNode> edges, BinaryRelation.Transient<IBasicBlock, IBasicBlock> blockEdges, Set<IBasicBlock> endBlocks) {
        HashMap<ICFGNode, IBasicBlock> builtBlocks = new HashMap<ICFGNode, IBasicBlock>();
        ArrayDeque<BlockBuilder> workList = new ArrayDeque<BlockBuilder>();
        BlockBuilder startState = new BlockBuilder(startNode);
        workList.push(startState);
        block4: while (!workList.isEmpty()) {
            BlockBuilder bbs = (BlockBuilder)workList.pop();
            block5: while (true) {
                Set.Immutable nexts = edges.get((Object)bbs.lastNode());
                switch (nexts.size()) {
                    case 0: {
                        assert (bbs.lastNode().getKind() == ICFGNode.Kind.End);
                        endBlocks.add(bbs.block);
                        break block5;
                    }
                    case 1: {
                        ICFGNode next = (ICFGNode)nexts.iterator().next();
                        if (edges.inverse().get((Object)next).size() == 1) {
                            bbs.addNode(next);
                            continue block5;
                        }
                        ControlFlowGraphBuilder.nextBlock(blockEdges, builtBlocks, workList, bbs, next);
                        break block5;
                    }
                    default: {
                        for (ICFGNode next : nexts) {
                            ControlFlowGraphBuilder.nextBlock(blockEdges, builtBlocks, workList, bbs, next);
                        }
                        continue block4;
                    }
                }
                break;
            }
        }
        return startState.block;
    }

    public static void nextBlock(BinaryRelation.Transient<IBasicBlock, IBasicBlock> blockEdges, Map<ICFGNode, IBasicBlock> mergePoints, Deque<BlockBuilder> workList, BlockBuilder bbs, ICFGNode next) {
        IBasicBlock nextBlock = mergePoints.get(next);
        if (nextBlock == null) {
            BlockBuilder nextBbs = new BlockBuilder(next);
            workList.push(nextBbs);
            nextBlock = nextBbs.block;
            mergePoints.put(next, nextBlock);
        }
        blockEdges.__insert((Object)bbs.block, (Object)nextBlock);
    }

    private static final class BlockBuilder {
        private final Deque<ICFGNode> blockDeque = new ArrayDeque<ICFGNode>();
        public final IBasicBlock block = new BasicBlock(this.blockDeque);

        public BlockBuilder(ICFGNode node) {
            this.addNode(node);
        }

        public ICFGNode lastNode() {
            return this.blockDeque.getLast();
        }

        public void addNode(ICFGNode node) {
            this.blockDeque.addLast(node);
        }
    }
}

