/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import io.usethesource.capsule.BinaryRelation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import mb.flowspec.controlflow.IBasicBlock;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.IControlFlowGraph;
import mb.flowspec.graph.Algorithms;

public class ControlFlowGraph
implements IControlFlowGraph,
Serializable {
    private final BinaryRelation.Immutable<IBasicBlock, IBasicBlock> blockEdges;
    private final Set<IBasicBlock> startBlocks;
    private final Set<IBasicBlock> endBlocks;
    private final BinaryRelation.Immutable<ICFGNode, ICFGNode> edges;
    private final Set<ICFGNode> startNodes;
    private final Set<ICFGNode> endNodes;
    private final Set<ICFGNode> entryNodes;
    private final Set<ICFGNode> exitNodes;
    private final Set<ICFGNode> normalNodes;
    private transient Collection<Set<IBasicBlock>> topoSCCs;
    private transient Collection<Set<IBasicBlock>> revTopoSCCs;
    private final int nodeCount;

    private ControlFlowGraph(BinaryRelation.Immutable<ICFGNode, ICFGNode> edges, BinaryRelation.Immutable<IBasicBlock, IBasicBlock> blockEdges, Set<IBasicBlock> startBlocks, Set<IBasicBlock> endBlocks, Set<ICFGNode> startNodes, Set<ICFGNode> endNodes, Set<ICFGNode> entryNodes, Set<ICFGNode> exitNodes, Set<ICFGNode> normalNodes) {
        this.edges = edges;
        this.blockEdges = blockEdges;
        this.startBlocks = startBlocks;
        this.endBlocks = endBlocks;
        this.startNodes = startNodes;
        this.endNodes = endNodes;
        this.entryNodes = entryNodes;
        this.exitNodes = exitNodes;
        this.normalNodes = normalNodes;
        this.nodeCount = this.computeNodeCount();
    }

    public BinaryRelation.Immutable<IBasicBlock, IBasicBlock> blockEdges() {
        return this.blockEdges;
    }

    @Override
    public Set<IBasicBlock> startBlocks() {
        return this.startBlocks;
    }

    @Override
    public Set<IBasicBlock> endBlocks() {
        return this.endBlocks;
    }

    public BinaryRelation.Immutable<ICFGNode, ICFGNode> edges() {
        return this.edges;
    }

    @Override
    public Set<ICFGNode> nextNodes(ICFGNode from) {
        return this.edges.get((Object)from);
    }

    @Override
    public Set<ICFGNode> prevNodes(ICFGNode from) {
        return this.edges.inverse().get((Object)from);
    }

    @Override
    public Set<IBasicBlock> nextBlocks(IBasicBlock from) {
        return this.blockEdges().get((Object)from);
    }

    @Override
    public Set<IBasicBlock> prevBlocks(IBasicBlock from) {
        return this.blockEdges().inverse().get((Object)from);
    }

    @Override
    public Set<ICFGNode> startNodes() {
        return this.startNodes;
    }

    @Override
    public Set<ICFGNode> endNodes() {
        return this.endNodes;
    }

    @Override
    public Set<ICFGNode> entryNodes() {
        return this.entryNodes;
    }

    @Override
    public Set<ICFGNode> exitNodes() {
        return this.exitNodes;
    }

    @Override
    public Set<ICFGNode> normalNodes() {
        return this.normalNodes;
    }

    public Collection<Set<IBasicBlock>> topoSCCs() {
        if (this.topoSCCs == null) {
            this.topoSCCs = Algorithms.topoSCCs(this.startBlocks, arg_0 -> this.blockEdges.get(arg_0));
            assert (ControlFlowGraph.countNodesinSCCs(this.topoSCCs) == this.nodeCount) : "Not all nodes found in topoSCCs, missing: " + (this.nodeCount - ControlFlowGraph.countNodesinSCCs(this.revTopoSCCs));
        }
        return this.topoSCCs;
    }

    public Collection<Set<IBasicBlock>> revTopoSCCs() {
        if (this.revTopoSCCs == null) {
            this.revTopoSCCs = Algorithms.revTopoSCCs(arg_0 -> ((BinaryRelation.Immutable)this.blockEdges.inverse()).get(arg_0), this.topoSCCs());
            assert (ControlFlowGraph.countNodesinSCCs(this.revTopoSCCs) == this.nodeCount) : "Not all nodes found in revTopoSCCs, missing: " + (this.nodeCount - ControlFlowGraph.countNodesinSCCs(this.revTopoSCCs));
        }
        return this.revTopoSCCs;
    }

    private static int countNodesinSCCs(Collection<Set<IBasicBlock>> sccs) {
        int count = 0;
        for (Set<IBasicBlock> scc : sccs) {
            for (IBasicBlock b : scc) {
                count += b.size();
            }
        }
        return count;
    }

    @Override
    public int nodeCount() {
        return this.nodeCount;
    }

    private int computeNodeCount() {
        return this.startNodes().size() + this.endNodes().size() + this.normalNodes().size() + this.entryNodes().size() + this.exitNodes().size();
    }

    @Override
    public int edgeCount() {
        return this.edges().size();
    }

    @Override
    public int blockCount() {
        return this.blockEdges().sizeDistinct();
    }

    @Override
    public int blockEdgeCount() {
        return this.blockEdges().size();
    }

    public static IControlFlowGraph of(BinaryRelation.Immutable<ICFGNode, ICFGNode> edges, BinaryRelation.Immutable<IBasicBlock, IBasicBlock> blockEdges, Set<IBasicBlock> startBlocks, Set<IBasicBlock> endBlocks, Set<ICFGNode> startNodes, Set<ICFGNode> endNodes, Set<ICFGNode> entryNodes, Set<ICFGNode> exitNodes, Set<ICFGNode> normalNodes) {
        return new ControlFlowGraph(edges, blockEdges, startBlocks, endBlocks, startNodes, endNodes, entryNodes, exitNodes, normalNodes);
    }
}

