/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util.function;

import oracle.pgx.common.util.function.SupplierWithException;
import oracle.pgx.common.util.function.WrappedFunctionException;

@FunctionalInterface
public interface RunnableWithException<T extends Throwable>
extends Runnable {
    public void runWithException() throws T;

    @Override
    default public void run() {
        try {
            this.runWithException();
        }
        catch (Throwable t) {
            throw new WrappedFunctionException(t);
        }
    }

    default public SupplierWithException<Void, T> toSupplierWithException() {
        return () -> {
            this.runWithException();
            return null;
        };
    }
}

