/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleModule
extends SimpleModule {
    private static final Logger LOG = LoggerFactory.getLogger(DoubleSerializer.class);
    private static final String DOUBLE_QUOTE = "\"";

    public DoubleModule() {
        super("DoubleModule", Version.unknownVersion());
        this.addSerializer(Double.class, new DoubleSerializer());
    }

    private static String serialize(Double d) {
        if (d.isInfinite() || d.isNaN()) {
            return DOUBLE_QUOTE + d + DOUBLE_QUOTE;
        }
        BigDecimal bd = BigDecimal.valueOf(d);
        return bd.toString();
    }

    private class DoubleSerializer
    extends JsonSerializer<Double> {
        private DoubleSerializer() {
        }

        public void serialize(Double value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
            LOG.trace("DoubleSerializer value before: {}", (Object)value);
            String stringValue = DoubleModule.serialize(value);
            LOG.trace("DoubleSerializer value after: {}", (Object)stringValue);
            gen.writeNumber(stringValue);
        }
    }
}

