/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.pgx.common.util.ErrorMessages;

public class DateUtils {
    public static Date parseDate(String str, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateWithLeniency(str, null, parsePatterns, true);
    }

    public static Date parseDate(String str, Locale locale, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateWithLeniency(str, locale, parsePatterns, true);
    }

    private static Date parseDateWithLeniency(String str, Locale locale, String[] parsePatterns, boolean lenient) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = locale == null ? Locale.getDefault() : locale;
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : parsePatterns) {
            SimpleDateFormat fdp = new SimpleDateFormat(parsePattern, lcl);
            fdp.setLenient(true);
            fdp.setTimeZone(tz);
            fdp.setCalendar(calendar);
            calendar.clear();
            try {
                Date result = fdp.parse(str, pos);
                if (result != null && pos.getIndex() == str.length()) {
                    return calendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new ParseException(ErrorMessages.getMessage("ILLEGAL_DATE_STRING", str), -1);
    }
}

