/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.filter;

import oracle.pgx.api.filter.FilterType;
import oracle.pgx.api.filter.GraphFilterWithExpression;
import oracle.pgx.api.filter.internal.EdgeCollectionFilter;
import oracle.pgx.api.filter.internal.ResultSetEdgeFilter;
import oracle.pgx.common.IdentifiableEdgeCollection;
import oracle.pgx.common.IdentifiableResultSet;

public class EdgeFilter
extends GraphFilterWithExpression {
    public static final EdgeFilter ALL = new EdgeFilter("true");
    public static final EdgeFilter NONE = new EdgeFilter("false");

    public static EdgeFilter fromExpression(String filterExpression) {
        return new EdgeFilter(filterExpression);
    }

    public static EdgeFilter fromPgqlResultSet(IdentifiableResultSet resultSet, String columnName) {
        return new ResultSetEdgeFilter(resultSet, columnName);
    }

    public static EdgeFilter fromCollection(IdentifiableEdgeCollection edgeCollection) {
        return new EdgeCollectionFilter(edgeCollection);
    }

    public EdgeFilter(String filterExpression) {
        super(FilterType.EDGE, filterExpression);
    }

    public String toString() {
        return "EdgeFilter(\"" + this.getFilterExpression() + "\")";
    }

    @Override
    public EdgeFilter asEdgeFilter() {
        return this;
    }
}

