/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.shell.aargparse.impl.converter;

import oracle.pgx.shell.aargparse.Argument;
import oracle.pgx.shell.aargparse.ArgumentConverter;
import oracle.pgx.shell.aargparse.ArgumentParser;

public abstract class PrimitiveConverter<T>
implements ArgumentConverter<T> {
    private final Class<?> expectedClazz;

    public PrimitiveConverter(Class<?> expectedClazz) {
        if (expectedClazz == null) {
            throw new IllegalArgumentException("given expected class is null");
        }
        this.expectedClazz = expectedClazz;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) {
        if (value == null) {
            throw new IllegalArgumentException("no value was provided");
        }
        T convertedValue = this.doConvert(parser, arg, value);
        return convertedValue;
    }

    protected abstract T doConvert(ArgumentParser var1, Argument var2, String var3);

    public static class PrimitiveBooleanConverter
    extends PrimitiveConverter<Boolean> {
        public PrimitiveBooleanConverter() {
            super(Boolean.class);
        }

        @Override
        protected Boolean doConvert(ArgumentParser parser, Argument arg, String value) {
            return Boolean.parseBoolean(value);
        }
    }

    public static class PrimitiveStringConverter
    extends PrimitiveConverter<String> {
        public PrimitiveStringConverter() {
            super(String.class);
        }

        @Override
        protected String doConvert(ArgumentParser parser, Argument arg, String value) {
            return value;
        }
    }

    public static class PrimitiveLongConverter
    extends PrimitiveConverter<Long> {
        public PrimitiveLongConverter() {
            super(Long.TYPE);
        }

        @Override
        protected Long doConvert(ArgumentParser parser, Argument arg, String value) {
            return Long.parseLong(value);
        }
    }

    public static class PrimitiveIntegerConverter
    extends PrimitiveConverter<Integer> {
        public PrimitiveIntegerConverter() {
            super(Integer.TYPE);
        }

        @Override
        protected Integer doConvert(ArgumentParser parser, Argument arg, String value) {
            return Integer.parseInt(value);
        }
    }
}

