/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.pgql.lang.ir.CommonPathExpression;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.Projection;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.ir.TableExpression;

public class SelectQuery
extends GraphQuery {
    private Projection projection;

    public SelectQuery(List<CommonPathExpression> commonPathExpressions, Projection projection, SchemaQualifiedName graphName, List<TableExpression> tableExpressions, Set<QueryExpression> constraints, GroupBy groupBy, QueryExpression having, OrderBy orderBy, QueryExpression limit, QueryExpression offset) {
        super(commonPathExpressions, graphName, tableExpressions, constraints, groupBy, having, orderBy, limit, offset);
        this.projection = projection;
    }

    public SelectQuery(List<CommonPathExpression> commonPathExpressions, Projection projection, SchemaQualifiedName graphName, List<TableExpression> tableExpressions, GroupBy groupBy, QueryExpression having, OrderBy orderBy, QueryExpression limit, QueryExpression offset) {
        this(commonPathExpressions, projection, graphName, tableExpressions, new LinkedHashSet<QueryExpression>(), groupBy, having, orderBy, limit, offset);
    }

    @Deprecated
    public SelectQuery(List<CommonPathExpression> commonPathExpressions, Projection projection, String inputGraphName, GraphPattern graphPattern, GroupBy groupBy, QueryExpression having, OrderBy orderBy, QueryExpression limit, QueryExpression offset) {
        this(commonPathExpressions, projection, new SchemaQualifiedName(null, inputGraphName), graphPattern, groupBy, having, orderBy, limit, offset);
    }

    @Deprecated
    public SelectQuery(List<CommonPathExpression> commonPathExpressions, Projection projection, SchemaQualifiedName graphName, GraphPattern graphPattern, GroupBy groupBy, QueryExpression having, OrderBy orderBy, QueryExpression limit, QueryExpression offset) {
        this(commonPathExpressions, projection, graphName, Collections.singletonList(graphPattern), groupBy, having, orderBy, limit, offset);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.SELECT;
    }

    @Override
    public StatementType getStatementType() {
        return StatementType.SELECT;
    }

    @Override
    public Projection getProjection() {
        return this.projection;
    }

    @Override
    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectQuery other = (SelectQuery)obj;
        return !(this.projection == null ? other.projection != null : !this.projection.equals(other.projection));
    }

    @Override
    public void accept(QueryExpressionVisitor v) {
        v.visit(this);
    }
}

