/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.util.ChangeTrackingMap;

public class ChangeTrackingSet<V> {
    private final ChangeTrackingMap<V, V> values = new ChangeTrackingMap();

    public void trackAdd(V value) {
        if (this.values.hasChangeFor(value)) {
            return;
        }
        this.values.trackAdd(value, value);
    }

    public void trackRemove(V value) {
        this.values.trackRemove(value);
    }

    public void reset(V value) {
        this.values.reset(value);
    }

    public ChangeType getChange(V value) {
        ChangeTrackingMap.ChangeSetEntry<V, V> change = this.values.getChange(value);
        if (change == null) {
            return null;
        }
        return change.getChangeType();
    }

    public boolean contains(ChangeTrackingMap.ChangeSetEntry<V, V> change) {
        if (change == null) {
            return false;
        }
        V value = change.getKey();
        return Objects.equals(this.values.getChange(value), change);
    }

    public boolean hasChangeFor(V value) {
        return this.getChange(value) != null;
    }

    public int size() {
        return this.values.size();
    }

    public List<ChangeTrackingMap.ChangeSetEntry<V, V>> getChanges() {
        return new ArrayList<ChangeTrackingMap.ChangeSetEntry<V, V>>(this.values.getChanges());
    }

    public Stream<ChangeTrackingMap.ChangeSetEntry<V, V>> stream() {
        return this.values.getChanges().stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeTrackingSet that = (ChangeTrackingSet)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return "ChangeTrackingSet: " + this.values;
    }
}

