/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.TransitionMode;
import oracle.security.pki.exception.AuthException;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1Date;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.CRL;
import oracle.security.pki.internal.cert.Certificate;
import oracle.security.pki.internal.cert.Entity;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.internal.cert.X509ExtensionSet;
import oracle.security.pki.internal.cert.ext.BasicConstraintsExtension;
import oracle.security.pki.internal.cert.ext.ExtKeyUsageExtension;
import oracle.security.pki.internal.cert.ext.IssuerAltNameExtension;
import oracle.security.pki.internal.cert.ext.KeyUsageExtension;
import oracle.security.pki.internal.cert.ext.SubjectAltNameExtension;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.KeyWrapper;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class X509
extends Certificate
implements ASN1Object {
    private ASN1Sequence e;
    private AlgorithmIdentifier f;
    private byte[] g;
    private BigInteger h;
    private X500Name i;
    private Date j;
    private Date k;
    private X509ExtensionSet l = null;
    private PrivateKey m;
    private CRL n;
    private X509Certificate o;
    protected boolean c = false;
    private int p = 3;
    private boolean[] q;
    private boolean[] r;
    private ASN1Sequence s = null;
    X509CertificateImpl d = new X509CertificateImpl();

    public X509() {
    }

    public X509(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public X509(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.input(inputStream);
        inputStream.close();
    }

    public static X509 a(X509Certificate x509Certificate) {
        if (x509Certificate instanceof X509CertificateImpl) {
            return ((X509CertificateImpl)x509Certificate).a();
        }
        try {
            return new X509(x509Certificate.getEncoded());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException(certificateEncodingException);
        }
    }

    public X509(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, int n, AlgorithmIdentifier algorithmIdentifier) throws SignatureException {
        this();
        this.a = x500Name;
        this.b = publicKey;
        this.i = x500Name2;
        this.m = privateKey;
        this.h = bigInteger;
        this.a(n);
        if (algorithmIdentifier != null) {
            this.a(algorithmIdentifier);
        }
        this.e();
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2, AlgorithmIdentifier algorithmIdentifier) throws SignatureException {
        this();
        this.a = x500Name;
        this.i = x500Name2;
        this.b = publicKey;
        this.m = privateKey;
        this.h = bigInteger;
        this.h = bigInteger;
        this.j = date;
        this.k = date2;
        if (algorithmIdentifier != null) {
            this.a(algorithmIdentifier);
        }
        this.e();
    }

    protected void d() {
        this.c = true;
    }

    public void e() throws SignatureException {
        if (!this.c) {
            this.d();
        }
        if (this.m == null) {
            throw new SignatureException("Cannot sign certificate, no issuer private key set");
        }
        ASN1Sequence aSN1Sequence = this.S();
        try {
            if (this.f == null) {
                throw new SignatureException("Cannot sign certificate, no signature algorithm set");
            }
            if (this.m.getAlgorithm().equals("RSA") && CryptoUtils.getSignatureAlg(this.f).contains("ECDSA")) {
                throw new SignatureException("Cannot create ECDSA signature using RSA keys");
            }
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.f));
            signature.initSign(this.m);
            signature.update(Utils.toBytes(aSN1Sequence));
            this.g = signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
        this.U();
    }

    public byte[] f() throws SignatureException {
        if (!this.c) {
            this.d();
        }
        if (this.g == null) {
            this.e();
        }
        return this.g;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        int n;
        int n2;
        Object object;
        Serializable serializable;
        Object object2;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.e = new ASN1Sequence(aSN1SequenceInputStream);
        this.f = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.g = ASN1BitString.a(aSN1SequenceInputStream);
        aSN1SequenceInputStream.b();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.e));
        if (aSN1SequenceInputStream2.d() == 0) {
            object2 = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            serializable = ASN1Integer.b((InputStream)object2);
            this.p = serializable.intValue() + 1;
            ((ASN1ConstructedInputStream)object2).b();
        }
        this.h = ASN1Integer.b(aSN1SequenceInputStream2);
        object2 = new AlgorithmIdentifier(aSN1SequenceInputStream2);
        if (!((AlgorithmIdentifier)object2).equals(this.f)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        serializable = new X500Name(aSN1SequenceInputStream2);
        if (this.i == null) {
            this.i = serializable;
        } else if (!this.i.equals(serializable)) {
            throw new IOException("Expected issuer {" + this.i + "}, got issuer {" + serializable + "}");
        }
        ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
        this.j = ASN1Date.a(aSN1SequenceInputStream3);
        this.k = ASN1Date.a(aSN1SequenceInputStream3);
        aSN1SequenceInputStream3.b();
        this.a = new X500Name(aSN1SequenceInputStream2);
        this.b = CryptoUtils.inputSPKI(aSN1SequenceInputStream2);
        if (aSN1SequenceInputStream2.d() == 1) {
            object = new ASN1BitString(aSN1SequenceInputStream2);
            this.q = new boolean[((ASN1BitString)object).e()];
            n2 = ((ASN1BitString)object).e();
            for (n = 0; n < n2; ++n) {
                this.q[n] = ((ASN1BitString)object).a(n);
            }
        }
        if (aSN1SequenceInputStream2.d() == 2) {
            aSN1SequenceInputStream2.a(3);
            object = new ASN1BitString(aSN1SequenceInputStream2);
            this.r = new boolean[((ASN1BitString)object).e()];
            n2 = ((ASN1BitString)object).e();
            for (n = 0; n < n2; ++n) {
                this.r[n] = ((ASN1BitString)object).a(n);
            }
        }
        if (aSN1SequenceInputStream2.d() == 3) {
            object = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.l = new X509ExtensionSet((InputStream)object);
            ((ASN1ConstructedInputStream)object).b();
        } else {
            this.l = null;
        }
        aSN1SequenceInputStream2.b();
        this.U();
    }

    private ASN1Sequence S() throws SignatureException {
        if (!this.c) {
            this.d();
        }
        if (this.e == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.l != null && this.l.c() > 0) {
                aSN1Sequence.a(new ASN1GenericConstructed(new ASN1Integer(2L), 0));
            }
            aSN1Sequence.a(new ASN1Integer(this.h));
            if (this.f == null && this.m != null) {
                if (this.m.getAlgorithm().equals("RSA")) {
                    this.f = AlgID.A;
                } else if (this.m.getAlgorithm().equals("DSA")) {
                    this.f = AlgID.D;
                } else if (this.m.getAlgorithm().equals("EC")) {
                    int n = ((ECPrivateKey)this.m).getParams().getCurve().getField().getFieldSize();
                    switch (n) {
                        case 256: {
                            this.f = AlgID.H;
                            break;
                        }
                        case 384: {
                            this.f = AlgID.I;
                            break;
                        }
                        case 512: {
                            this.f = AlgID.J;
                            break;
                        }
                        default: {
                            this.f = AlgID.G;
                        }
                    }
                }
            }
            if (this.f == null) {
                throw new SignatureException("Cannot build to-be-signed certificate, no signature algorithm set");
            }
            aSN1Sequence.a(this.f);
            aSN1Sequence.a(this.i);
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.j);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.k);
            aSN1Sequence2.a(new ASN1Date(this.j, calendar.get(1) > 2049));
            aSN1Sequence2.a(new ASN1Date(this.k, calendar2.get(1) > 2049));
            aSN1Sequence.a(aSN1Sequence2);
            aSN1Sequence.a((X500Name)this.a);
            KeyWrapper keyWrapper = null;
            try {
                keyWrapper = new KeyWrapper();
                keyWrapper.initialize("Public", this.b);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            aSN1Sequence.a(CryptoUtils.subjectPublicKeyInfo(keyWrapper));
            if (this.l != null && this.l.c() > 0) {
                aSN1Sequence.a(new ASN1GenericConstructed(this.l, 3));
            }
            this.e = aSN1Sequence;
        }
        return this.e;
    }

    private ASN1Sequence T() throws SignatureException {
        if (this.s == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.S());
            aSN1Sequence.a(this.f);
            aSN1Sequence.a(new ASN1BitString(this.f()));
            this.s = aSN1Sequence;
        }
        return this.s;
    }

    private void U() {
        this.s = null;
    }

    private void V() {
        this.U();
        this.e = null;
        this.g = null;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.T().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException);
        }
    }

    @Override
    public int length() {
        try {
            return this.T().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException);
        }
    }

    public byte[] g() {
        try {
            return Utils.toBytes(this.T());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException);
        }
    }

    @Override
    public boolean a() throws AuthException {
        if (!this.c) {
            this.d();
        }
        if (this.p()) {
            return false;
        }
        if (!this.h()) {
            return false;
        }
        if (this.o != null) {
            if (!this.W()) {
                return false;
            }
            if (!this.i.equals(this.o.getSubjectX500Principal())) {
                return false;
            }
            if (!this.i()) {
                return false;
            }
        }
        return this.n == null || this.j();
    }

    private boolean W() {
        boolean[] blArray;
        if (!this.c) {
            this.d();
        }
        return (blArray = this.o.getKeyUsage()) == null || blArray[5];
    }

    public boolean h() {
        Date date;
        if (!this.c) {
            this.d();
        }
        return !(date = new Date()).before(this.j) && !date.after(this.k);
    }

    public boolean i() throws AuthException {
        if (!this.c) {
            this.d();
        }
        if (this.o == null) {
            throw new IllegalStateException("Issuer certificate not set");
        }
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.f));
            signature.initVerify(this.o.getPublicKey());
            signature.update(Utils.toBytes(this.S()));
            return signature.verify(this.f());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthException(noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new AuthException(signatureException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthException(invalidKeyException);
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new AuthException(streamableOutputException);
        }
    }

    public boolean j() {
        if (!this.c) {
            this.d();
        }
        if (this.n == null) {
            throw new IllegalStateException("Issuer CRL not set");
        }
        return !this.n.d(this.h);
    }

    @Override
    public Entity c() {
        if (!this.c) {
            this.d();
        }
        return this.a;
    }

    public void a(X500Name x500Name) {
        this.a = x500Name;
        this.V();
    }

    @Override
    public PublicKey b() {
        if (!this.c) {
            this.d();
        }
        return this.b;
    }

    public void a(PublicKey publicKey) {
        this.b = publicKey;
    }

    public Date k() {
        if (!this.c) {
            this.d();
        }
        return this.j;
    }

    public void a(Date date) {
        this.j = date;
        this.V();
    }

    public Date l() {
        if (!this.c) {
            this.d();
        }
        return this.k;
    }

    public void b(Date date) {
        this.k = date;
        this.V();
    }

    public void a(int n) {
        this.j = new Date();
        this.k = Utils.daysFrom(this.j, n);
        this.V();
    }

    public X500Name m() {
        if (!this.c) {
            this.d();
        }
        return (X500Name)this.a;
    }

    public void b(X500Name x500Name) {
        this.a = x500Name;
        this.V();
    }

    public X500Name n() {
        if (!this.c) {
            this.d();
        }
        return this.i;
    }

    public void c(X500Name x500Name) {
        this.i = x500Name;
        if (this.n != null && !x500Name.equals(this.n.a())) {
            throw new IllegalStateException("Certificate issuer does not match CRL issuer");
        }
        this.V();
    }

    public void a(X509 x509) {
        this.b(x509.u());
    }

    public void b(X509Certificate x509Certificate) {
        this.o = x509Certificate;
        if (this.i == null) {
            if (x509Certificate instanceof X509CertificateImpl) {
                this.c(((X509CertificateImpl)x509Certificate).a().n());
            } else {
                this.c(X500Name.a(x509Certificate.getIssuerX500Principal()));
            }
        }
    }

    public void a(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.m = privateKey;
        this.a(algorithmIdentifier);
    }

    public void a(AlgorithmIdentifier algorithmIdentifier) {
        this.f = algorithmIdentifier;
        this.V();
    }

    public void a(CRL cRL) {
        if (!this.c) {
            this.d();
        }
        this.n = cRL;
        if (this.i != null && !this.i.equals(cRL.a())) {
            throw new IllegalStateException("CRL issuer does not match certificate issuer");
        }
    }

    public BigInteger o() {
        if (!this.c) {
            this.d();
        }
        return this.h;
    }

    public void a(BigInteger bigInteger) {
        this.h = bigInteger;
        this.V();
    }

    public boolean p() {
        if (!this.c) {
            this.d();
        }
        return this.l != null && this.l.d();
    }

    public X509ExtensionSet q() {
        if (!this.c) {
            this.d();
        }
        return this.l;
    }

    public X509Extension a(ASN1ObjectID aSN1ObjectID) {
        if (!this.c) {
            this.d();
        }
        return this.l != null ? this.l.a(aSN1ObjectID) : null;
    }

    public void a(X509ExtensionSet x509ExtensionSet) {
        this.l = x509ExtensionSet;
        this.V();
    }

    public void a(X509Extension x509Extension) {
        if (!this.c) {
            this.d();
        }
        if (this.l == null) {
            this.l = new X509ExtensionSet();
        }
        this.l.a(x509Extension);
        this.V();
    }

    public byte[] r() {
        if (!this.c) {
            this.d();
        }
        try {
            String string = TransitionMode.isFIPS140ModeEnabled() ? "SHA-256" : "MD5";
            MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(string);
            return messageDigest.digest(Utils.toBytes(this.T()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("MessageDigest algorithm not available.", noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException);
        }
    }

    public static byte[] a(X500Name x500Name, BigInteger bigInteger, MessageDigest messageDigest) {
        try {
            messageDigest.update(x500Name.toString().getBytes("ASCII"));
            messageDigest.update(bigInteger.toString().getBytes("ASCII"));
            return messageDigest.digest();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public byte[] a(String string) {
        try {
            MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(string);
            if (!this.c) {
                this.d();
            }
            messageDigest.update(this.i.toString().getBytes("ASCII"));
            messageDigest.update(this.h.toString().getBytes("ASCII"));
            return messageDigest.digest();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public ASN1ObjectID s() {
        try {
            this.S();
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException);
        }
        if (this.f != null) {
            return this.f.a();
        }
        throw new IllegalStateException("Signature algorithm not defined");
    }

    public String t() {
        String string = null;
        string = CryptoUtils.getSignatureAlg(new AlgorithmIdentifier(this.s()));
        if (string == null) {
            string = this.s().d();
        }
        return string;
    }

    public boolean a(byte[] byArray, byte[] byArray2, AlgorithmIdentifier algorithmIdentifier) throws AuthException {
        if (!this.c) {
            this.d();
        }
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(algorithmIdentifier));
            signature.initVerify(this.b);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new AuthException(signatureException);
        }
    }

    public boolean equals(Object object) {
        if (!this.c) {
            this.d();
        }
        if (object == null) {
            return false;
        }
        if (object instanceof X509) {
            return Utils.areEqual(Utils.toBytes(this), Utils.toBytes((X509)object));
        }
        if (object instanceof X509Certificate) {
            try {
                return Utils.areEqual(Utils.toBytes(this), ((X509Certificate)object).getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (!this.c) {
            this.d();
        }
        return Arrays.hashCode(Utils.toBytes(this));
    }

    public String toString() {
        Object object;
        if (!this.c) {
            this.d();
        }
        String string = "";
        string = string + "{ fingerprint = " + Utils.toHexString(this.r());
        string = string + ", notBefore = " + this.j;
        string = string + ", notAfter = " + this.k;
        string = string + ", holder = " + this.a;
        string = string + ", issuer = " + this.i;
        string = string + ", serialNo = " + this.h;
        string = string + ", sigAlgOID = " + this.t();
        string = string + ", key = ";
        if (this.b instanceof RSAKey) {
            String string2 = "{ modulus = ";
            if (this.b instanceof RSAPublicKey) {
                object = (RSAPublicKey)this.b;
                string2 = string2 + object.getModulus() + ", exponent = " + object.getPublicExponent();
            } else {
                object = (RSAPrivateCrtKey)((Object)this.b);
                string2 = string2 + object.getModulus() + ", exponent = " + object.getPrivateExponent();
            }
            string = string + string2;
        }
        if (this.l != null && this.l.c() > 0) {
            string = string + ", extensions = {";
            boolean bl = false;
            object = this.l.b().iterator();
            while (object.hasNext()) {
                if (bl) {
                    string = string + ", ";
                }
                string = string + object.next();
                bl = true;
            }
            string = string + " }";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }

    public X509Certificate u() {
        return this.d;
    }

    public void v() throws CertificateExpiredException, CertificateNotYetValidException {
        this.c(new Date());
    }

    public void c(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.j)) {
            throw new CertificateNotYetValidException("Certificate not yet valid");
        }
        if (date.after(this.k)) {
            throw new CertificateExpiredException("Certificate expired");
        }
    }

    public int w() {
        BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.l.a(PKIX.H);
        if (basicConstraintsExtension == null) {
            return -1;
        }
        if (!basicConstraintsExtension.e()) {
            return 0;
        }
        if (basicConstraintsExtension.f() == null) {
            return Integer.MAX_VALUE;
        }
        return basicConstraintsExtension.f().intValue();
    }

    public Principal x() {
        return this.n().g();
    }

    public X500Principal y() {
        return this.n().g();
    }

    public X500Principal z() {
        return this.m().g();
    }

    public boolean[] A() {
        return this.q;
    }

    public boolean[] B() {
        KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.l.a(PKIX.E);
        return keyUsageExtension.f();
    }

    public Date C() {
        return this.l();
    }

    public Date D() {
        return this.k();
    }

    public BigInteger E() {
        return this.o();
    }

    public String F() {
        return CryptoUtils.getSignatureAlg(this.f);
    }

    public byte[] G() {
        return Utils.toBytes(this.f.b());
    }

    public byte[] H() {
        try {
            return this.f();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException);
        }
    }

    public Principal I() {
        return this.z();
    }

    public boolean[] J() {
        return this.r;
    }

    public byte[] K() throws CertificateEncodingException {
        try {
            return Utils.toBytes(this.S());
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException);
        }
    }

    public int L() {
        return this.p;
    }

    public void a(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null && !TransitionMode.isFIPS140ModeEnabled() ? Signature.getInstance(this.F(), string) : JCEUtil.getSignatureInstance(this.F());
        signature.initVerify(publicKey);
        signature.update(this.K());
        boolean bl = signature.verify(this.H());
        if (!bl) {
            throw new SignatureException("Public key does not match");
        }
    }

    public void b(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.a(publicKey, null);
    }

    public Set<String> M() {
        return this.l.getCriticalExtensionOIDs();
    }

    public byte[] b(String string) {
        return this.l.getExtensionValue(string);
    }

    public Set<String> N() {
        return this.l.getNonCriticalExtensionOIDs();
    }

    public boolean O() {
        return this.l.hasUnsupportedCriticalExtension();
    }

    public List<String> P() throws CertificateParsingException {
        ExtKeyUsageExtension extKeyUsageExtension = (ExtKeyUsageExtension)this.l.a(PKIX.U);
        if (extKeyUsageExtension == null) {
            return null;
        }
        ArrayList<ASN1ObjectID> arrayList = extKeyUsageExtension.e();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ASN1ObjectID aSN1ObjectID : arrayList) {
            arrayList2.add(aSN1ObjectID.d());
        }
        return arrayList2;
    }

    public Collection<List<?>> Q() throws CertificateParsingException {
        IssuerAltNameExtension issuerAltNameExtension = (IssuerAltNameExtension)this.l.a(PKIX.G);
        if (issuerAltNameExtension == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (GeneralName generalName : issuerAltNameExtension.e()) {
            arrayList.add(generalName.c());
        }
        return arrayList;
    }

    public Collection<List<?>> R() throws CertificateParsingException {
        SubjectAltNameExtension subjectAltNameExtension = (SubjectAltNameExtension)this.l.a(PKIX.F);
        if (subjectAltNameExtension == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (GeneralName generalName : subjectAltNameExtension.e()) {
            arrayList.add(generalName.c());
        }
        return arrayList;
    }

    class X509CertificateImpl
    extends X509Certificate {
        X509CertificateImpl() {
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            X509.this.v();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            X509.this.c(date);
        }

        @Override
        public int getBasicConstraints() {
            return X509.this.w();
        }

        @Override
        public Principal getIssuerDN() {
            return X509.this.x();
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return X509.this.y();
        }

        @Override
        public X500Principal getSubjectX500Principal() {
            return X509.this.z();
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return X509.this.A();
        }

        @Override
        public boolean[] getKeyUsage() {
            return X509.this.B();
        }

        @Override
        public Date getNotAfter() {
            return X509.this.C();
        }

        @Override
        public Date getNotBefore() {
            return X509.this.D();
        }

        @Override
        public BigInteger getSerialNumber() {
            return X509.this.E();
        }

        @Override
        public String getSigAlgName() {
            return X509.this.F();
        }

        @Override
        public String getSigAlgOID() {
            return X509.this.s().d();
        }

        @Override
        public byte[] getSigAlgParams() {
            return X509.this.G();
        }

        @Override
        public byte[] getSignature() {
            return X509.this.H();
        }

        @Override
        public Principal getSubjectDN() {
            return X509.this.I();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return X509.this.J();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return X509.this.K();
        }

        @Override
        public int getVersion() {
            return X509.this.L();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return X509.this.g();
        }

        @Override
        public PublicKey getPublicKey() {
            return X509.this.b();
        }

        @Override
        public String toString() {
            return X509.this.toString();
        }

        @Override
        public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            X509.this.a(publicKey, string);
        }

        @Override
        public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            X509.this.b(publicKey);
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return X509.this.M();
        }

        @Override
        public byte[] getExtensionValue(String string) {
            return X509.this.b(string);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return X509.this.N();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return X509.this.O();
        }

        @Override
        public List<String> getExtendedKeyUsage() throws CertificateParsingException {
            return X509.this.P();
        }

        @Override
        public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
            return X509.this.Q();
        }

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
            return X509.this.R();
        }

        @Override
        public boolean equals(Object object) {
            return X509.this.equals(object);
        }

        @Override
        public int hashCode() {
            return X509.this.hashCode();
        }

        public X509 a() {
            return X509.this;
        }
    }
}

