/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.marshalers.GenericMarshaler;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.mllib.DbModelStoringConfiguration;
import oracle.pgx.config.mllib.FileModelStoringConfiguration;
import oracle.pgx.config.mllib.ModelDatasource;
import oracle.pgx.config.mllib.ModelStoringConfiguration;

public class ModelStoringConfigurationDeserializer
extends JsonDeserializer<ModelStoringConfiguration> {
    public ModelStoringConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        ModelDatasource datasource = (ModelDatasource)JsonUtil.fromJsonNode((JsonNode)node.get("datasource"), ModelDatasource.class);
        String json = node.toString();
        switch (datasource) {
            case FILE: {
                return (ModelStoringConfiguration)new GenericMarshaler<FileModelStoringConfiguration>(FileModelStoringConfiguration.class).unmarshal(json);
            }
            case DB: {
                return (ModelStoringConfiguration)new GenericMarshaler<DbModelStoringConfiguration>(DbModelStoringConfiguration.class).unmarshal(json);
            }
        }
        throw new IllegalEnumConstantException((Enum)datasource);
    }
}

