/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.PgxGraphProperty;
import oracle.pgx.graphviz.driver.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PgxGraphInformation
implements GraphInformation {
    private static final Logger LOG = LoggerFactory.getLogger(PgxGraphInformation.class);
    private final String name;
    private final boolean verticesLabeled;
    private final boolean edgesLabeled;
    @Nonnull
    private final Set<Property> vertexProperties;
    @Nonnull
    private final Set<Property> edgeProperties;
    @Nonnull
    private final Set<String> vertexLabels;
    @Nonnull
    private final Set<String> edgeLabels;

    PgxGraphInformation(@Nonnull PgxGraph graph) {
        this.name = graph.getName();
        this.vertexProperties = this.mapProperties(graph.getVertexProperties());
        this.edgeProperties = this.mapProperties(graph.getEdgeProperties());
        this.verticesLabeled = graph.hasVertexLabels();
        this.edgesLabeled = graph.hasEdgeLabel();
        this.edgeLabels = PgxGraphInformation.getSetOfEdgeLabels(graph);
        this.vertexLabels = PgxGraphInformation.getSetOfVertexLabels(graph);
    }

    @Nullable
    public String getSchema() {
        return null;
    }

    public String getGraphName() {
        return this.name;
    }

    @Nonnull
    private static Set<String> getSetOfEdgeLabels(PgxGraph graph) {
        HashSet<String> edgeLabels = new HashSet<String>();
        graph.getMetaData().getEdgeProvidersMetaData().values().forEach(p -> edgeLabels.addAll(p.getLabels()));
        return edgeLabels;
    }

    @Nonnull
    private static Set<String> getSetOfVertexLabels(PgxGraph graph) {
        HashSet<String> vertexLabels = new HashSet<String>();
        graph.getMetaData().getVertexProvidersMetaData().values().forEach(p -> vertexLabels.addAll(p.getLabels()));
        return vertexLabels;
    }

    @Nonnull
    private static Property mapProperty(@Nonnull oracle.pgx.api.Property property) {
        return new PgxGraphProperty(property.getName(), PgxGraphInformation.isSelectable(property.getType()));
    }

    private static boolean isSelectable(@Nonnull PropertyType type) {
        return type != PropertyType.VERTEX && type != PropertyType.EDGE;
    }

    @Nonnull
    private Set<Property> mapProperties(Collection<? extends oracle.pgx.api.Property> properties) {
        if (properties == null) {
            return Collections.emptySet();
        }
        return properties.stream().filter(Objects::nonNull).map(PgxGraphInformation::mapProperty).collect(Collectors.toSet());
    }

    public boolean hasVertexLabels() {
        return this.verticesLabeled;
    }

    public boolean hasEdgeLabels() {
        return this.edgesLabeled;
    }

    @Nonnull
    public Set<Property> getVertexProperties() {
        return Collections.unmodifiableSet(this.vertexProperties);
    }

    @Nonnull
    public Set<Property> getEdgeProperties() {
        return Collections.unmodifiableSet(this.edgeProperties);
    }

    public Set<String> getVertexLabels() {
        return Collections.unmodifiableSet(this.vertexLabels);
    }

    public Set<String> getEdgeLabels() {
        return Collections.unmodifiableSet(this.edgeLabels);
    }
}

