/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.pypgx.internal;

import java.io.IOException;
import java.util.List;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.api.PgqlResultElement;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.pypgx.internal.SerializedColumn;

public class PythonClientResultSetUtil {
    private final PgqlResultSet resultSet;

    public PythonClientResultSetUtil(PgqlResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public SerializedColumn[] serialize() throws PgqlException, IOException {
        this.resultSet.absolute(0L);
        List resultElements = this.resultSet.getPgqlResultElements();
        int numColumns = resultElements.size();
        long numRowsLong = this.resultSet.getNumResults();
        if (numRowsLong >= Long.valueOf(Integer.MAX_VALUE)) {
            throw new ArithmeticException(String.format("We can only convert result sets up to %d to pandas frames.", Integer.MAX_VALUE));
        }
        int numRows = Math.toIntExact(numRowsLong);
        SerializedColumn[] serializedColumns = new SerializedColumn[numColumns];
        for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
            serializedColumns[columnIndex] = new SerializedColumn((PgqlResultElement)resultElements.get(columnIndex), numRows);
        }
        for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
            if (!this.resultSet.next()) {
                throw new IllegalStateException("PgqlResultSet cursor is out of bounds");
            }
            for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
                serializedColumns[columnIndex].write(this.resultSet.getObject(columnIndex + 1), rowIndex);
            }
        }
        return serializedColumns;
    }

    public Object[][] toList(int start, int end) throws PgqlException {
        if (start > end) {
            throw new PgqlException("start should be less than or equal to end");
        }
        this.resultSet.absolute((long)start);
        int columnSize = this.resultSet.getPgqlResultElements().size();
        Object[][] items = new Object[end - start][columnSize];
        for (int count = start; count < end; ++count) {
            if (!this.resultSet.next()) {
                throw new IllegalStateException("PgqlResultSet cursor is out of bounds");
            }
            for (int i = 1; i < columnSize + 1; ++i) {
                items[count - start][i - 1] = this.resultSet.getObject(i);
            }
        }
        return items;
    }
}

