/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.UdfFunctionArgumentConfig;

public final class UdfFunctionArgumentConfigBuilder {
    private final Map<UdfFunctionArgumentConfig.Field, Object> values = new HashMap<UdfFunctionArgumentConfig.Field, Object>();

    public static UdfFunctionArgumentConfig buildUdfFunctionArgumentConfig(Consumer<UdfFunctionArgumentConfigBuilder> builderSetup) {
        UdfFunctionArgumentConfigBuilder builder = new UdfFunctionArgumentConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public UdfFunctionArgumentConfigBuilder() {
    }

    public UdfFunctionArgumentConfigBuilder(Map<UdfFunctionArgumentConfig.Field, Object> values) {
        this.putAll(values);
    }

    public UdfFunctionArgumentConfigBuilder(UdfFunctionArgumentConfig config) {
        this.putAll(config);
    }

    public UdfFunctionArgumentConfigBuilder(UdfFunctionArgumentConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public UdfFunctionArgumentConfigBuilder putAll(Map<UdfFunctionArgumentConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public UdfFunctionArgumentConfigBuilder putAll(UdfFunctionArgumentConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public UdfFunctionArgumentConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public UdfFunctionArgumentConfig build(String parentPath) {
        try {
            return UdfFunctionArgumentConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public UdfFunctionArgumentConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<UdfFunctionArgumentConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "UdfFunctionArgumentConfigBuilder" + this.values;
    }

    public UdfFunctionArgumentConfigBuilder setName(String name) {
        this.values.put(UdfFunctionArgumentConfig.Field.NAME, name);
        return this;
    }

    public UdfFunctionArgumentConfigBuilder setType(PropertyType type) {
        this.values.put(UdfFunctionArgumentConfig.Field.TYPE, type);
        return this;
    }
}

