/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.FrontierRedactedVerticesConfig;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PgxRedactionRuleConfig;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.PropertiesRedactionRuleConfig;

public class PgxRedactionRulesConfig
extends AbstractConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static PgxRedactionRulesConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return PgxRedactionRulesConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static PgxRedactionRulesConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return PgxRedactionRulesConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static PgxRedactionRulesConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new PgxRedactionRulesConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static PgxRedactionRulesConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new PgxRedactionRulesConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static PgxRedactionRulesConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new PgxRedactionRulesConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected PgxRedactionRulesConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public List<PgxRedactionRuleConfig> getRedactionRules() {
        return (List)this.values.get(Field.REDACTION_RULES);
    }

    public List<String> getWithVisibleProperties() {
        return (List)this.values.get(Field.WITH_VISIBLE_PROPERTIES);
    }

    public String getLabel() {
        return (String)this.values.get(Field.LABEL);
    }

    public List<String> getProperties() {
        return (List)this.values.get(Field.PROPERTIES);
    }

    public String getRuleTrigger() {
        return (String)this.values.get(Field.RULE_TRIGGER);
    }

    public String getRuleName() {
        return (String)this.values.get(Field.RULE_NAME);
    }

    public String getRedactVertex() {
        return (String)this.values.get(Field.REDACT_VERTEX);
    }

    public FrontierRedactedVerticesConfig getShowFrontierVertex() {
        return (FrontierRedactedVerticesConfig)this.values.get(Field.SHOW_FRONTIER_VERTEX);
    }

    public String getRedactEdge() {
        return (String)this.values.get(Field.REDACT_EDGE);
    }

    public List<PropertiesRedactionRuleConfig> getRedactVertexProperties() {
        return (List)this.values.get(Field.REDACT_VERTEX_PROPERTIES);
    }

    public List<PropertiesRedactionRuleConfig> getRedactEdgeProperties() {
        return (List)this.values.get(Field.REDACT_EDGE_PROPERTIES);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgxRedactionRulesConfig other = (PgxRedactionRulesConfig)obj;
        if (!Objects.equals(this.getRedactionRules(), other.getRedactionRules())) {
            return false;
        }
        if (!Objects.equals(this.getWithVisibleProperties(), other.getWithVisibleProperties())) {
            return false;
        }
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (!Objects.equals(this.getProperties(), other.getProperties())) {
            return false;
        }
        if (!Objects.equals(this.getRuleTrigger(), other.getRuleTrigger())) {
            return false;
        }
        if (!Objects.equals(this.getRuleName(), other.getRuleName())) {
            return false;
        }
        if (!Objects.equals(this.getRedactVertex(), other.getRedactVertex())) {
            return false;
        }
        if (!Objects.equals(this.getShowFrontierVertex(), other.getShowFrontierVertex())) {
            return false;
        }
        if (!Objects.equals(this.getRedactEdge(), other.getRedactEdge())) {
            return false;
        }
        if (!Objects.equals(this.getRedactVertexProperties(), other.getRedactVertexProperties())) {
            return false;
        }
        return Objects.equals(this.getRedactEdgeProperties(), other.getRedactEdgeProperties());
    }

    public static enum Field implements ConfigField
    {
        REDACTION_RULES(Collections.emptyList(), Collections.emptyList(), PgxRedactionRuleConfig.class, false, Collections.emptyList(), true, false, false, false),
        WITH_VISIBLE_PROPERTIES(Collections.emptyList(), Collections.emptyList(), String.class, false, Collections.emptyList(), true, false, false, false),
        LABEL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        PROPERTIES(Collections.emptyList(), Collections.emptyList(), String.class, false, Collections.emptyList(), true, false, false, false),
        RULE_TRIGGER(Collections.emptyList(), Collections.emptyList(), String.class, false, "true", false, false, false, false),
        RULE_NAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        REDACT_VERTEX(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SHOW_FRONTIER_VERTEX(Collections.emptyList(), Collections.emptyList(), FrontierRedactedVerticesConfig.class, false, Collections.emptyMap(), false, false, false, false),
        REDACT_EDGE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        REDACT_VERTEX_PROPERTIES(Collections.emptyList(), Collections.emptyList(), PropertiesRedactionRuleConfig.class, false, Collections.emptyList(), true, false, false, false),
        REDACT_EDGE_PROPERTIES(Collections.emptyList(), Collections.emptyList(), PropertiesRedactionRuleConfig.class, false, Collections.emptyList(), true, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("pgx.redaction.rules.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

