/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.PgxRedactionRuleMappingConfig;

public final class PgxRedactionRuleMappingConfigBuilder {
    private final Map<PgxRedactionRuleMappingConfig.Field, Object> values = new HashMap<PgxRedactionRuleMappingConfig.Field, Object>();

    public static PgxRedactionRuleMappingConfig buildPgxRedactionRuleMappingConfig(Consumer<PgxRedactionRuleMappingConfigBuilder> builderSetup) {
        PgxRedactionRuleMappingConfigBuilder builder = new PgxRedactionRuleMappingConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public PgxRedactionRuleMappingConfigBuilder() {
    }

    public PgxRedactionRuleMappingConfigBuilder(Map<PgxRedactionRuleMappingConfig.Field, Object> values) {
        this.putAll(values);
    }

    public PgxRedactionRuleMappingConfigBuilder(PgxRedactionRuleMappingConfig config) {
        this.putAll(config);
    }

    public PgxRedactionRuleMappingConfigBuilder(PgxRedactionRuleMappingConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public PgxRedactionRuleMappingConfigBuilder putAll(Map<PgxRedactionRuleMappingConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public PgxRedactionRuleMappingConfigBuilder putAll(PgxRedactionRuleMappingConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public PgxRedactionRuleMappingConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public PgxRedactionRuleMappingConfig build(String parentPath) {
        try {
            return PgxRedactionRuleMappingConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public PgxRedactionRuleMappingConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<PgxRedactionRuleMappingConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "PgxRedactionRuleMappingConfigBuilder" + this.values;
    }

    public PgxRedactionRuleMappingConfigBuilder setRuleName(String ruleName) {
        this.values.put(PgxRedactionRuleMappingConfig.Field.RULE_NAME, ruleName);
        return this;
    }

    public PgxRedactionRuleMappingConfigBuilder setUsers(String ... users) {
        this.values.put(PgxRedactionRuleMappingConfig.Field.USERS, users);
        return this;
    }

    public PgxRedactionRuleMappingConfigBuilder setUsersExcluded(String ... usersExcluded) {
        this.values.put(PgxRedactionRuleMappingConfig.Field.USERS_EXCLUDED, usersExcluded);
        return this;
    }

    public PgxRedactionRuleMappingConfigBuilder setRoles(String ... roles) {
        this.values.put(PgxRedactionRuleMappingConfig.Field.ROLES, roles);
        return this;
    }

    public PgxRedactionRuleMappingConfigBuilder setRolesExcluded(String ... rolesExcluded) {
        this.values.put(PgxRedactionRuleMappingConfig.Field.ROLES_EXCLUDED, rolesExcluded);
        return this;
    }
}

