/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.types.Edge;
import oracle.pgx.common.types.Node;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.Row;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.types.Types;

public enum EntityType implements Type
{
    VERTEX(Node.class),
    EDGE(Edge.class),
    ROW(Row.class);

    private static final Map<String, EntityType> ALIASES;
    private final Class<?> typeClass;

    @JsonCreator
    public static EntityType parseEntityType(String input) {
        return Types.parse(EntityType.class, input, ALIASES);
    }

    private EntityType(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @Override
    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.toKey();
    }

    public PropertyType toPropertyType() {
        switch (this) {
            case VERTEX: {
                return PropertyType.VERTEX;
            }
            case EDGE: {
                return PropertyType.EDGE;
            }
        }
        throw new IllegalEnumConstantException(this);
    }

    static {
        ALIASES = new HashMap<String, EntityType>();
        ALIASES.put("NODE", VERTEX);
    }
}

