/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.loaders.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.loaders.location.EntityProviderLocation;

public final class FileEntityProviderLocation
extends EntityProviderLocation {
    private final List<String> filePaths;
    private final Map<String, String> attributes;

    public FileEntityProviderLocation(List<String> filePaths, EntityType entityType, @Nullable ProviderFormat format) {
        this(filePaths, entityType, format, null);
    }

    @JsonCreator
    public FileEntityProviderLocation(@JsonProperty(value="filePaths") List<String> filePaths, @JsonProperty(value="entityType") EntityType entityType, @JsonProperty(value="format") @Nullable ProviderFormat format, @JsonProperty(value="attributes") @Nullable Map<String, String> attributes) {
        super(EntityProviderLocation.LocationKind.FILE, entityType, format);
        assert (format == null || format.isFileFormat());
        this.filePaths = filePaths;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    public FileEntityProviderLocation(String path, EntityType entityType, @Nullable ProviderFormat format) {
        this(Collections.singletonList(path), entityType, format);
    }

    @Override
    @JsonInclude
    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isFileLocation() {
        return true;
    }
}

