/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.sdf2table.io.ParseTableIO;
import org.metaborg.spoofax.core.syntax.IParseTableProvider;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.terms.io.binary.TermReader;

public class JSGLR1FileParseTableProvider
implements IParseTableProvider {
    private final FileObject resource;
    private final ITermFactory termFactory;
    private ParseTable parseTable;

    public JSGLR1FileParseTableProvider(FileObject resource, ITermFactory termFactory) {
        this.resource = resource;
        this.termFactory = termFactory;
    }

    @Override
    public ParseTable parseTable() throws IOException {
        block16: {
            if (this.parseTable != null) {
                return this.parseTable;
            }
            this.resource.refresh();
            if (!this.resource.exists()) {
                throw new IOException("Could not load parse table from " + this.resource + ", file does not exist");
            }
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream stream = this.resource.getContent().getInputStream();){
                    TermReader termReader = new TermReader(this.termFactory);
                    IStrategoTerm parseTableTerm = termReader.parseFromStream(stream);
                    FileObject persistedTable = this.resource.getName().getBaseName().contains("-completions") ? this.resource.getParent().resolveFile("table-completions.bin") : this.resource.getParent().resolveFile("table.bin");
                    try {
                        this.parseTable = new ParseTable(parseTableTerm, this.termFactory);
                    }
                    catch (Exception e) {
                        if (persistedTable.exists() && e.getMessage() == "Parse table does not contain any state and normalized grammar is null") {
                            this.parseTable = new ParseTable(parseTableTerm, this.termFactory, new ParseTableIO(persistedTable.getContent().getInputStream(), true));
                            break block16;
                        }
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new IOException("Could not load parse table from " + this.resource, e);
            }
        }
        return this.parseTable;
    }
}

