/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build.paths;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.build.paths.ILanguagePathProvider;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.project.IProject;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class LanguagePathService
implements ILanguagePathService {
    private static final ILogger logger = LoggerUtils.logger(LanguagePathService.class);
    private final ILanguageIdentifierService languageIdentifierService;
    private final Set<ILanguagePathProvider> providers;

    @Inject
    public LanguagePathService(ILanguageIdentifierService languageIdentifierService, Set<ILanguagePathProvider> providers) {
        this.languageIdentifierService = languageIdentifierService;
        this.providers = providers;
    }

    public Set<FileObject> sourcePaths(IProject project, String languageName) {
        return this.getFileObjects("source", provider -> provider.sourcePaths(project, languageName));
    }

    public Set<FileObject> includePaths(IProject project, String languageName) {
        return this.getFileObjects("include", provider -> provider.includePaths(project, languageName));
    }

    public Set<FileObject> getFileObjects(String pathKind, CheckedFunction1<ILanguagePathProvider, Iterable<FileObject>, MetaborgException> getPaths) {
        TreeSet sources = new TreeSet(Comparator.reverseOrder());
        for (ILanguagePathProvider provider : this.providers) {
            try {
                Iterable<FileObject> providedSources = getPaths.apply(provider);
                Iterables2.addAll(sources, providedSources);
            }
            catch (MetaborgException e) {
                logger.error("Getting " + pathKind + " paths from provider {} failed unexpectedly, skipping this provider", e, provider);
            }
        }
        return Collections.unmodifiableSortedSet(sources);
    }

    @Override
    public Iterable<FileObject> sourceAndIncludePaths(IProject project, String languageName) {
        ImList.Mutable<FileObject> paths = ImList.Mutable.of(new FileObject[0]);
        paths.addAll((Collection<FileObject>)this.sourcePaths(project, languageName));
        paths.addAll((Collection<FileObject>)this.includePaths(project, languageName));
        return paths.freeze();
    }

    @Override
    public Iterable<IdentifiedResource> sourceFiles(IProject project, ILanguageImpl language) {
        Iterable sourcePaths = this.sourcePaths(project, language.belongsTo().name());
        return this.toFiles(sourcePaths, language);
    }

    @Override
    public Iterable<IdentifiedResource> includeFiles(IProject project, ILanguageImpl language) {
        Iterable includePaths = this.includePaths(project, language.belongsTo().name());
        return this.toFiles(includePaths, language);
    }

    @Override
    public Iterable<IdentifiedResource> sourceAndIncludeFiles(IProject project, ILanguageImpl language) {
        Iterable<FileObject> paths = this.sourceAndIncludePaths(project, language.belongsTo().name());
        return this.toFiles((Iterable)paths, language);
    }

    public Collection<IdentifiedResource> toFiles(Iterable<FileObject> paths, ILanguageImpl language) {
        Collection<FileObject> files = ResourceUtils.expand(paths);
        ArrayList<IdentifiedResource> identifiedFiles = new ArrayList<IdentifiedResource>(files.size());
        for (FileObject file : files) {
            IdentifiedResource identifiedFile = this.languageIdentifierService.identifyToResource(file, Iterables2.singleton(language));
            if (identifiedFile == null) continue;
            identifiedFiles.add(identifiedFile);
        }
        return identifiedFiles;
    }
}

