/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.MatchResult;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.matching.VarProvider;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.VoidException;
import mb.statix.constraints.CExists;
import mb.statix.constraints.Constraints;
import mb.statix.solver.IConstraint;
import mb.statix.solver.StateUtil;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;

class ApplyRelaxed
extends ApplyMode<VoidException> {
    ApplyRelaxed() {
    }

    @Override
    Optional<ApplyResult> apply(IUniDisunifier.Immutable unifier, Rule rule, List<? extends ITerm> args, IConstraint cause, ApplyMode.Safety safety, boolean trackOrigins) throws VoidException {
        Optional<Object> diseq;
        ICompleteness.Immutable newCriticalEdges;
        IConstraint newBody;
        IUniDisunifier.Result unifyResult;
        Set.Immutable freeVars = rule.freeVars();
        for (ITerm iTerm : args) {
            freeVars = freeVars.__insertAll(iTerm.getVars());
        }
        FreshVars freshVars = new FreshVars((Iterable<ITermVar>)freeVars);
        VarProvider freshProvider = VarProvider.of(freshVars::fresh, () -> fresh.fresh("_"));
        MatchResult matchResult = TermPattern.P.matchWithEqs(rule.params(), args, unifier, freshProvider).orElse(null);
        if (matchResult == null) {
            return Optional.empty();
        }
        Set.Immutable<ITermVar> generatedVars = freshVars.reset();
        Set.Immutable constrainedVars = Set.Immutable.subtract(matchResult.constrainedVars(), generatedVars);
        IConstraint appliedBody = safety.equals((Object)ApplyMode.Safety.UNSAFE) ? rule.body().unsafeApply(matchResult.substitution(), trackOrigins).withCause(cause) : rule.body().apply(matchResult.substitution(), trackOrigins).withCause(cause);
        ICompleteness.Immutable appliedCriticalEdges = rule.bodyCriticalEdges() == null ? null : rule.bodyCriticalEdges().apply(matchResult.substitution());
        try {
            unifyResult = unifier.unify(matchResult.equalities()).orElse(null);
            if (unifyResult == null) {
                return Optional.empty();
            }
        }
        catch (OccursException e) {
            return Optional.empty();
        }
        IUnifier.Immutable diff = (IUnifier.Immutable)unifyResult.result();
        IUnifier.Immutable guard = diff.retainAll((Set.Immutable<ITermVar>)constrainedVars).unifier();
        if (guard.isEmpty()) {
            newBody = appliedBody;
            newCriticalEdges = appliedCriticalEdges;
            diseq = Optional.empty();
        } else {
            ICompleteness.Immutable newBodyCriticalEdges = appliedCriticalEdges == null ? null : appliedCriticalEdges.retainAll((Collection<? extends ITerm>)generatedVars, unifier);
            newBody = new CExists((Iterable<ITermVar>)generatedVars, Constraints.conjoin(StateUtil.asEqualities(diff), appliedBody), cause, newBodyCriticalEdges);
            newCriticalEdges = appliedCriticalEdges == null ? null : appliedCriticalEdges.removeAll((Collection<? extends ITerm>)generatedVars, unifier);
            diseq = Optional.of(Diseq.of(generatedVars, guard));
        }
        ApplyResult applyResult = ApplyResult.of(diseq, newBody, newCriticalEdges != null ? newCriticalEdges : Completeness.Immutable.of(), matchResult.substitution());
        return Optional.of(applyResult);
    }
}

