/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public final class CInequal
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<ITermVar> universals;
    private final ITerm term1;
    private final ITerm term2;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;
    @Nullable
    private final CInequal origin;
    private final int hashCode = this.computeHashCode();

    public CInequal(Iterable<ITermVar> universals, ITerm term1, ITerm term2) {
        this(universals, term1, term2, null, null, null);
    }

    public CInequal(Iterable<ITermVar> universals, ITerm term1, ITerm term2, @Nullable IMessage message) {
        this(universals, term1, term2, null, message, null);
    }

    private CInequal(Iterable<ITermVar> universals, ITerm term1, ITerm term2, @Nullable IConstraint cause, @Nullable IMessage message, @Nullable CInequal origin) {
        this.universals = CapsuleUtil.toSet(universals);
        this.term1 = term1;
        this.term2 = term2;
        this.cause = cause;
        this.message = message;
        this.origin = origin;
    }

    public Set<ITermVar> universals() {
        return this.universals;
    }

    public ITerm term1() {
        return this.term1;
    }

    public ITerm term2() {
        return this.term2;
    }

    public CInequal withArguments(Iterable<ITermVar> universals, ITerm term1, ITerm term2) {
        if (this.universals == universals && this.term1 == term1 && this.term2 == term2) {
            return this;
        }
        return new CInequal(universals, term1, term2, this.cause, this.message, this.origin);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CInequal withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CInequal((Iterable<ITermVar>)this.universals, this.term1, this.term2, cause, this.message, this.origin);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CInequal withMessage(@Nullable IMessage message) {
        if (this.message == message) {
            return this;
        }
        return new CInequal((Iterable<ITermVar>)this.universals, this.term1, this.term2, this.cause, message, this.origin);
    }

    @Override
    @Nullable
    public CInequal origin() {
        return this.origin;
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseInequal(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseInequal(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        Set.Transient vars = CapsuleUtil.transientSet();
        vars.__insertAll(this.universals);
        vars.__insertAll(this.term1.getVars());
        vars.__insertAll(this.term2.getVars());
        return vars.freeze();
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.term1.getVars().stream().filter(v -> !this.universals.contains(v)).forEach(onFreeVar::apply);
        this.term2.getVars().stream().filter(v -> !this.universals.contains(v)).forEach(onFreeVar::apply);
        if (this.message != null) {
            this.message.visitVars(onFreeVar);
        }
    }

    @Override
    public CInequal apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CInequal unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CInequal apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CInequal apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        Set.Immutable us = (Set.Immutable)this.universals.stream().flatMap(v -> subst.apply((ITerm)v).getVars().stream()).collect(CapsuleCollectors.toSet());
        return new CInequal((Iterable<ITermVar>)us, subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public CInequal unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return this.apply(subst, trackOrigin);
    }

    @Override
    public CInequal apply(IRenaming subst, boolean trackOrigin) {
        Set.Immutable us = (Set.Immutable)this.universals.stream().map(subst::rename).collect(CapsuleCollectors.toSet());
        return new CInequal((Iterable<ITermVar>)us, subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        if (!this.universals.isEmpty()) {
            sb.append("(forall ");
            sb.append(this.universals.stream().map(termToString::format).collect(Collectors.joining(", ")));
            sb.append(". ");
        }
        sb.append(termToString.format(this.term1));
        sb.append(" != ");
        sb.append(termToString.format(this.term2));
        if (!this.universals.isEmpty()) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CInequal that = (CInequal)o;
        return this.hashCode == that.hashCode && Objects.equals(this.universals, that.universals) && Objects.equals(this.term1, that.term1) && Objects.equals(this.term2, that.term2) && Objects.equals(this.cause, that.cause) && Objects.equals(this.message, that.message) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.universals, this.term1, this.term2, this.cause, this.message, this.origin);
    }
}

