/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent.nameresolution;

import io.usethesource.capsule.Set;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.matching.Transform;
import mb.p_raffrayi.IScopeImpl;
import mb.statix.scopegraph.Scope;
import org.metaborg.util.collection.BiMap;
import org.metaborg.util.collection.BiMaps;
import org.metaborg.util.collection.CapsuleUtil;

public class ScopeImpl
implements IScopeImpl<Scope, ITerm> {
    @Override
    public Scope make(String id, String name) {
        return Scope.of(id, name);
    }

    @Override
    public String id(Scope scope) {
        return scope.getResource();
    }

    @Override
    public ITerm substituteScopes(ITerm datum, Map<Scope, Scope> substitution) {
        return Transform.T.sometd(Scope.matcher().map(s -> substitution.getOrDefault(s, (Scope)s))::match).apply(datum);
    }

    @Override
    public Set.Immutable<Scope> getScopes(ITerm datum) {
        return CapsuleUtil.toSet(Transform.T.collecttd(Scope.matcher()::match).apply(datum));
    }

    @Override
    public ITerm embed(Scope scope) {
        return scope;
    }

    @Override
    public Optional<BiMap.Immutable<Scope>> matchDatums(ITerm currentDatum, ITerm previousDatum) {
        return this.termMatch(currentDatum, previousDatum);
    }

    private Optional<BiMap.Immutable<Scope>> termMatch(ITerm left, ITerm right) {
        Optional<Scope> leftScope = Scope.matcher().match(left);
        if (leftScope.isPresent()) {
            Optional<Scope> rightScope = Scope.matcher().match(right);
            if (!rightScope.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(BiMap.Immutable.of(leftScope.get(), rightScope.get()));
        }
        return left.match(Terms.cases(applLeft -> right.match(Terms.cases().appl(applRight -> {
            if (applLeft.getArity() == applRight.getArity() && applLeft.getOp().equals(applRight.getOp())) {
                return this.termsMatch(applLeft.getArgs(), applRight.getArgs());
            }
            return Optional.empty();
        }).otherwise(t -> Optional.empty())), listLeft -> right.match(Terms.cases().list(listRight -> this.listMatch((IListTerm)listLeft, (IListTerm)listRight)).otherwise(t -> Optional.of(BiMap.Immutable.of()))), stringLeft -> right.match(Terms.cases().string(stringRight -> ScopeImpl.fromEquality(stringLeft.getValue().equals(stringRight.getValue()))).otherwise(t -> Optional.empty())), integerLeft -> right.match(Terms.cases().integer(integerRight -> ScopeImpl.fromEquality(integerLeft.getValue() == integerRight.getValue())).otherwise(t -> Optional.empty())), blobLeft -> right.match(Terms.cases().blob(blobRight -> ScopeImpl.fromEquality(blobLeft.getValue().equals(blobRight.getValue()))).otherwise(t -> Optional.empty())), varLeft -> right.match(Terms.cases().var(varRight -> ScopeImpl.fromEquality(varLeft.equals(varRight))).otherwise(termRight -> Optional.empty()))));
    }

    private Optional<BiMap.Immutable<Scope>> listMatch(IListTerm left, IListTerm right) {
        return left.match(ListTerms.cases(consLeft -> right.match(ListTerms.cases().cons(consRight -> this.termMatch(consLeft.getHead(), consRight.getHead()).flatMap(headMatches -> this.listMatch(consLeft.getTail(), consRight.getTail()).flatMap(tailMatches -> BiMaps.safeMerge(headMatches, tailMatches)))).otherwise(l -> Optional.empty())), nilLeft -> right.match(ListTerms.cases().nil(nilRight -> Optional.of(BiMap.Immutable.of())).otherwise(l -> Optional.empty())), varLeft -> right.match(ListTerms.cases().var(varRight -> ScopeImpl.fromEquality(varLeft.equals(varRight))).otherwise(termRight -> Optional.empty()))));
    }

    private Optional<BiMap.Immutable<Scope>> termsMatch(List<ITerm> lefts, List<ITerm> rights) {
        if (lefts.size() != rights.size()) {
            return Optional.empty();
        }
        if (lefts.isEmpty()) {
            return Optional.of(BiMap.Immutable.of());
        }
        return this.termMatch(lefts.get(0), rights.get(0)).flatMap(headMatch -> {
            List<ITerm> leftsSub = lefts.subList(1, lefts.size());
            List<ITerm> rightsSub = rights.subList(1, rights.size());
            return this.termsMatch(leftsSub, rightsSub).flatMap(tailMatch -> BiMaps.safeMerge(headMatch, tailMatch));
        });
    }

    private static Optional<BiMap.Immutable<Scope>> fromEquality(boolean equal) {
        return equal ? Optional.of(BiMap.Immutable.of()) : Optional.empty();
    }
}

