/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import io.usethesource.capsule.Map;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IIncrementalTypeCheckerContext;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.statix.concurrent.AbstractTypeChecker;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.SolverState;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.tracer.SolverTracer;
import mb.statix.spec.Rule;
import mb.statix.spec.Spec;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class GroupTypeChecker<TR extends SolverTracer.IResult<TR>>
extends AbstractTypeChecker<GroupResult<TR>, TR> {
    private static final ILogger logger = LoggerUtils.logger(GroupTypeChecker.class);
    private final IStatixGroup group;

    public GroupTypeChecker(IStatixGroup group, Spec spec, IDebugContext debug, Supplier<SolverTracer<TR>> tracerFactory, int solverFlags) {
        super(spec, debug, tracerFactory, solverFlags);
        this.group = group;
    }

    @Override
    public IFuture<GroupResult<TR>> run(IIncrementalTypeCheckerContext<Scope, ITerm, ITerm, GroupResult<TR>, SolverState> context, List<Scope> rootScopes) {
        List<Scope> thisGroupScopes = this.group.scopeNames().stream().map(name -> this.makeSharedScope((ITypeCheckerContext<Scope, ITerm, ITerm>)context, (String)name)).collect(Collectors.toList());
        IFuture groupResults = this.runGroups(context, this.group.groups(), thisGroupScopes);
        IFuture unitResults = this.runUnits(context, this.group.units(), thisGroupScopes);
        thisGroupScopes.forEach(context::closeScope);
        Optional<Rule> rule = this.group.rule();
        String resource = this.group.resource();
        ImList.Mutable<Scope> scopesBuilder = new ImList.Mutable<Scope>(rootScopes.size() + thisGroupScopes.size());
        scopesBuilder.addAll(rootScopes);
        scopesBuilder.addAll(thisGroupScopes);
        ImList.Immutable scopes = scopesBuilder.freeze();
        return context.runIncremental(initialState -> {
            logger.debug("group {}: running. restarted: {}.", resource, initialState.isPresent());
            return this.runSolver((ITypeCheckerContext<Scope, ITerm, ITerm>)context, rule, (Optional<SolverState>)initialState, scopes);
        }, GroupResult::solveResult, this::patch, (result, ex) -> {
            logger.debug("group {}: combining.", resource);
            return AggregateFuture.apply(groupResults, unitResults).thenApply(e -> {
                logger.debug("group {}: returning.", resource);
                return GroupResult.of(resource, (Map.Immutable)e._1(), (Map.Immutable)e._2(), result, ex);
            });
        }).whenComplete((r, __) -> logger.debug("group {}: returned.", context.id()));
    }
}

