/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.esop15.reference;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mb.nabl2.util.collections.IndexedBagMultimap;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.esop15.CriticalEdge;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.HashTrieFunction;
import org.metaborg.util.collection.HashTrieRelation3;
import org.metaborg.util.collection.IFunction;
import org.metaborg.util.collection.IRelation3;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Predicate3;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.tuple.Tuple2;

public abstract class EsopScopeGraph<S extends IScope, L extends ILabel, O extends IOccurrence, V>
implements IEsopScopeGraph<S, L, O, V> {
    protected EsopScopeGraph() {
    }

    @Override
    public Set.Immutable<S> getAllScopes() {
        Set.Transient allScopes = CapsuleUtil.transientSet();
        allScopes.__insertAll(this.getDecls().valueSet());
        allScopes.__insertAll(this.getRefs().valueSet());
        allScopes.__insertAll(this.getDirectEdges().keySet());
        allScopes.__insertAll(this.getDirectEdges().valueSet());
        allScopes.__insertAll(this.getExportEdges().valueSet());
        allScopes.__insertAll(this.getImportEdges().keySet());
        this.incompleteDirectEdges().forEach(e -> {
            boolean bl = allScopes.__insert((Object)((IScope)((Tuple2)e.getKey())._1()));
        });
        this.incompleteImportEdges().forEach(e -> {
            boolean bl = allScopes.__insert((Object)((IScope)((Tuple2)e.getKey())._1()));
        });
        return allScopes.freeze();
    }

    @Override
    public Set.Immutable<O> getAllDecls() {
        Set.Transient allDecls = CapsuleUtil.transientSet();
        allDecls.__insertAll(this.getDecls().keySet());
        allDecls.__insertAll(this.getExportEdges().keySet());
        return allDecls.freeze();
    }

    @Override
    public Set.Immutable<O> getAllRefs() {
        Set.Transient allRefs = CapsuleUtil.transientSet();
        allRefs.__insertAll(this.getRefs().keySet());
        allRefs.__insertAll(this.getImportEdges().valueSet());
        return allRefs.freeze();
    }

    @Override
    public boolean isComplete() {
        return this.incompleteDirectEdges().isEmpty() && this.incompleteImportEdges().isEmpty();
    }

    public static class Immutable<S extends IScope, L extends ILabel, O extends IOccurrence, V>
    extends EsopScopeGraph<S, L, O, V>
    implements IEsopScopeGraph.Immutable<S, L, O, V>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final IFunction.Immutable<O, S> decls;
        private final IFunction.Immutable<O, S> refs;
        private final IRelation3.Immutable<S, L, S> directEdges;
        private final IRelation3.Immutable<O, L, S> assocEdges;
        private final IRelation3.Immutable<S, L, O> importEdges;
        private final Map.Immutable<Tuple2<S, L>, V> incompleteDirectEdges;
        private final Map.Immutable<Tuple2<S, L>, V> incompleteImportEdges;

        Immutable(IFunction.Immutable<O, S> decls, IFunction.Immutable<O, S> refs, IRelation3.Immutable<S, L, S> directEdges, IRelation3.Immutable<O, L, S> assocEdges, IRelation3.Immutable<S, L, O> importEdges, Map.Immutable<Tuple2<S, L>, V> incompleteDirectEdges, Map.Immutable<Tuple2<S, L>, V> incompleteImportEdges) {
            this.decls = decls;
            this.refs = refs;
            this.directEdges = directEdges;
            this.assocEdges = assocEdges;
            this.importEdges = importEdges;
            this.incompleteDirectEdges = incompleteDirectEdges;
            this.incompleteImportEdges = incompleteImportEdges;
        }

        @Override
        public boolean isOpen(S scope, L label) {
            Tuple2<S, L> key = Tuple2.of(scope, label);
            return this.incompleteDirectEdges.containsKey(key) || this.incompleteImportEdges.containsKey(key);
        }

        @Override
        public IFunction.Immutable<O, S> getDecls() {
            return this.decls;
        }

        @Override
        public IFunction.Immutable<O, S> getRefs() {
            return this.refs;
        }

        @Override
        public IRelation3.Immutable<S, L, S> getDirectEdges() {
            return this.directEdges;
        }

        @Override
        public Collection<? extends Map.Entry<Tuple2<S, L>, V>> incompleteDirectEdges() {
            return this.incompleteDirectEdges.entrySet();
        }

        @Override
        public IRelation3.Immutable<O, L, S> getExportEdges() {
            return this.assocEdges;
        }

        @Override
        public IRelation3.Immutable<S, L, O> getImportEdges() {
            return this.importEdges;
        }

        @Override
        public Collection<? extends Map.Entry<Tuple2<S, L>, V>> incompleteImportEdges() {
            return this.incompleteImportEdges.entrySet();
        }

        @Override
        public Transient<S, L, O, V> melt() {
            return new Transient(this.decls.melt(), this.refs.melt(), this.directEdges.melt(), this.assocEdges.melt(), this.importEdges.melt(), this.incompleteDirectEdges.asTransient(), this.incompleteImportEdges.asTransient());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.decls.hashCode();
            result = 31 * result + this.refs.hashCode();
            result = 31 * result + this.directEdges.hashCode();
            result = 31 * result + this.assocEdges.hashCode();
            result = 31 * result + this.importEdges.hashCode();
            result = 31 * result + this.incompleteDirectEdges.hashCode();
            result = 31 * result + this.incompleteImportEdges.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.decls.equals(other.decls)) {
                return false;
            }
            if (!this.refs.equals(other.refs)) {
                return false;
            }
            if (!this.directEdges.equals(other.directEdges)) {
                return false;
            }
            if (!this.assocEdges.equals(other.assocEdges)) {
                return false;
            }
            if (!this.importEdges.equals(other.importEdges)) {
                return false;
            }
            if (!this.incompleteDirectEdges.equals(other.incompleteDirectEdges)) {
                return false;
            }
            return this.incompleteImportEdges.equals(other.incompleteImportEdges);
        }

        public static <S extends IScope, L extends ILabel, O extends IOccurrence, V> Immutable<S, L, O, V> of() {
            return new Immutable(HashTrieFunction.Immutable.of(), HashTrieFunction.Immutable.of(), HashTrieRelation3.Immutable.of(), HashTrieRelation3.Immutable.of(), HashTrieRelation3.Immutable.of(), CapsuleUtil.immutableMap(), Map.Immutable.of());
        }
    }

    public static class Transient<S extends IScope, L extends ILabel, O extends IOccurrence, V>
    extends EsopScopeGraph<S, L, O, V>
    implements IEsopScopeGraph.Transient<S, L, O, V> {
        private final IFunction.Transient<O, S> decls;
        private final IFunction.Transient<O, S> refs;
        private final IRelation3.Transient<S, L, S> directEdges;
        private final IRelation3.Transient<O, L, S> assocEdges;
        private final IRelation3.Transient<S, L, O> importEdges;
        private final IndexedBagMultimap<Tuple2<S, L>, V, V> incompleteDirectEdges;
        private final IndexedBagMultimap<Tuple2<S, L>, V, V> incompleteImportEdges;

        Transient(IFunction.Transient<O, S> decls, IFunction.Transient<O, S> refs, IRelation3.Transient<S, L, S> directEdges, IRelation3.Transient<O, L, S> assocEdges, IRelation3.Transient<S, L, O> importEdges, Map.Transient<Tuple2<S, L>, V> incompleteDirectEdges, Map.Transient<Tuple2<S, L>, V> incompleteImportEdges) {
            this.decls = decls;
            this.refs = refs;
            this.directEdges = directEdges;
            this.assocEdges = assocEdges;
            this.importEdges = importEdges;
            this.incompleteDirectEdges = new IndexedBagMultimap(IndexedBagMultimap.RemovalPolicy.ALL);
            incompleteDirectEdges.entrySet().forEach(e -> this.incompleteDirectEdges.put(Tuple2.of((IScope)((Tuple2)e.getKey())._1(), (ILabel)((Tuple2)e.getKey())._2()), e.getValue(), Iterables2.singleton(e.getValue())));
            this.incompleteImportEdges = new IndexedBagMultimap(IndexedBagMultimap.RemovalPolicy.ALL);
            incompleteImportEdges.entrySet().forEach(e -> this.incompleteImportEdges.put(Tuple2.of((IScope)((Tuple2)e.getKey())._1(), (ILabel)((Tuple2)e.getKey())._2()), e.getValue(), Iterables2.singleton(e.getValue())));
        }

        @Override
        public boolean isOpen(S scope, L label) {
            Tuple2<S, L> key = Tuple2.of(scope, label);
            return this.incompleteDirectEdges.containsKey(key) || this.incompleteImportEdges.containsKey(key);
        }

        @Override
        public IFunction<O, S> getDecls() {
            return this.decls;
        }

        @Override
        public IFunction<O, S> getRefs() {
            return this.refs;
        }

        @Override
        public IRelation3<S, L, S> getDirectEdges() {
            return this.directEdges;
        }

        @Override
        public Collection<? extends Map.Entry<Tuple2<S, L>, V>> incompleteDirectEdges() {
            return this.incompleteDirectEdges.entries();
        }

        @Override
        public IRelation3<O, L, S> getExportEdges() {
            return this.assocEdges;
        }

        @Override
        public IRelation3<S, L, O> getImportEdges() {
            return this.importEdges;
        }

        @Override
        public Collection<? extends Map.Entry<Tuple2<S, L>, V>> incompleteImportEdges() {
            return this.incompleteImportEdges.entries();
        }

        @Override
        public Collection<V> incompleteVars() {
            ArrayList<V> result = new ArrayList<V>();
            result.addAll(this.incompleteDirectEdges.indices());
            result.addAll(this.incompleteImportEdges.indices());
            return result;
        }

        @Override
        public boolean addDecl(S scope, O decl) {
            return this.decls.put(decl, scope) == null;
        }

        @Override
        public boolean addRef(O ref, S scope) {
            return this.refs.put(ref, scope) == null;
        }

        @Override
        public boolean addDirectEdge(S sourceScope, L label, S targetScope) {
            return this.directEdges.put(sourceScope, label, targetScope);
        }

        @Override
        public boolean addIncompleteDirectEdge(S scope, L label, V var, Function1<V, ? extends Set.Immutable<? extends V>> norm) {
            this.incompleteDirectEdges.put(Tuple2.of(scope, label), var, (Iterable)norm.apply(var));
            return true;
        }

        @Override
        public boolean addExportEdge(O decl, L label, S scope) {
            return this.assocEdges.put(decl, label, scope);
        }

        @Override
        public boolean addIncompleteImportEdge(S scope, L label, V var, Function1<V, ? extends Set.Immutable<? extends V>> norm) {
            this.incompleteImportEdges.put(Tuple2.of(scope, label), var, (Iterable)norm.apply(var));
            return true;
        }

        @Override
        public boolean addImportEdge(S scope, L label, O ref) {
            return this.importEdges.put(scope, label, ref);
        }

        @Override
        public boolean addAll(IEsopScopeGraph<S, L, O, V> other, Function1<V, ? extends Set.Immutable<? extends V>> norm) {
            boolean change = false;
            change |= other.getDecls().stream().filter(e -> this.addDecl((IScope)e._2(), (IOccurrence)e._1())).count() > 0L;
            change |= other.getRefs().stream().filter(e -> this.addRef((IOccurrence)e._1(), (IScope)e._2())).count() > 0L;
            change |= other.getDirectEdges().stream().filter(e -> this.addDirectEdge((IScope)e._1(), (ILabel)e._2(), (IScope)e._3())).count() > 0L;
            change |= other.getExportEdges().stream().filter(e -> this.addExportEdge((IOccurrence)e._1(), (ILabel)e._2(), (IScope)e._3())).count() > 0L;
            change |= other.getImportEdges().stream().filter(e -> this.addImportEdge((IScope)e._1(), (ILabel)e._2(), (IOccurrence)e._3())).count() > 0L;
            change |= other.incompleteDirectEdges().stream().filter(e -> this.addIncompleteDirectEdge((IScope)((Tuple2)e.getKey())._1(), (ILabel)((Tuple2)e.getKey())._2(), e.getValue(), norm)).count() > 0L;
            return change |= other.incompleteImportEdges().stream().filter(e -> this.addIncompleteImportEdge((IScope)((Tuple2)e.getKey())._1(), (ILabel)((Tuple2)e.getKey())._2(), e.getValue(), norm)).count() > 0L;
        }

        @Override
        public List<CriticalEdge> reduceAll(Function1<V, ? extends Set.Immutable<? extends V>> norm, Function1<V, S> fs, Function1<V, O> fo) {
            return this.reduce(this.incompleteVars(), norm, fs, fo);
        }

        @Override
        public List<CriticalEdge> reduce(Iterable<? extends V> vs, Function1<V, ? extends Set.Immutable<? extends V>> norm, Function1<V, S> fs, Function1<V, O> fo) {
            ImList.Mutable<CriticalEdge> reduced = ImList.Mutable.of(new CriticalEdge[0]);
            this.reduce(this.incompleteDirectEdges, vs, norm, fs, this::addDirectEdge, reduced);
            this.reduce(this.incompleteImportEdges, vs, norm, fo, this::addImportEdge, reduced);
            return reduced.freeze();
        }

        private <X> void reduce(IndexedBagMultimap<Tuple2<S, L>, V, V> index, Iterable<? extends V> vs, Function1<V, ? extends Set.Immutable<? extends V>> norm, Function1<V, X> f, Predicate3<S, L, X> add2, ImList.Mutable<CriticalEdge> reduced) {
            for (V v : vs) {
                for (Map.Entry entry : index.reindex(v, norm)) {
                    X x = f.apply(entry.getValue());
                    IScope s = (IScope)((Tuple2)entry.getKey())._1();
                    ILabel l = (ILabel)((Tuple2)entry.getKey())._2();
                    add2.test(s, l, x);
                    reduced.add(CriticalEdge.of(s, l));
                }
            }
        }

        @Override
        public Immutable<S, L, O, V> freeze() {
            return new Immutable(this.decls.freeze(), this.refs.freeze(), this.directEdges.freeze(), this.assocEdges.freeze(), this.importEdges.freeze(), CapsuleUtil.toMap(this.incompleteDirectEdges.entries()), CapsuleUtil.toMap(this.incompleteImportEdges.entries()));
        }

        public static <S extends IScope, L extends ILabel, O extends IOccurrence, V> Transient<S, L, O, V> of() {
            return new Transient(HashTrieFunction.Transient.of(), HashTrieFunction.Transient.of(), HashTrieRelation3.Transient.of(), HashTrieRelation3.Transient.of(), HashTrieRelation3.Transient.of(), CapsuleUtil.transientMap(), Map.Transient.of());
        }
    }
}

