/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.regex.Pattern;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.PathMatcher;
import mb.resource.util.SeparatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RegexPathMatcher
implements PathMatcher {
    private final String pattern;
    private transient Pattern compiledPattern;

    public RegexPathMatcher(String pattern) {
        this.pattern = pattern;
        this.compiledPattern = Pattern.compile(pattern);
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        String relative = SeparatorUtil.convertCurrentToUnixSeparator(rootDir.relativize(path));
        return this.compiledPattern.matcher(relative).matches();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexPathMatcher that = (RegexPathMatcher)o;
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return "with-regex(" + this.pattern + ")";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.compiledPattern = Pattern.compile(this.pattern);
    }
}

