/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi;

import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.APRaffrayiSettings;

public final class PRaffrayiSettings
extends APRaffrayiSettings {
    private final boolean recording;
    private final boolean incrementalDeadlock;
    private final boolean scopeGraphDiff;
    private final boolean confirmation;
    private transient int hashCode;

    private PRaffrayiSettings(boolean recording, boolean incrementalDeadlock, boolean scopeGraphDiff, boolean confirmation) {
        this.recording = recording;
        this.incrementalDeadlock = incrementalDeadlock;
        this.scopeGraphDiff = scopeGraphDiff;
        this.confirmation = confirmation;
    }

    @Override
    public boolean recording() {
        return this.recording;
    }

    @Override
    public boolean incrementalDeadlock() {
        return this.incrementalDeadlock;
    }

    @Override
    public boolean scopeGraphDiff() {
        return this.scopeGraphDiff;
    }

    @Override
    public boolean confirmation() {
        return this.confirmation;
    }

    public final PRaffrayiSettings withRecording(boolean value) {
        if (this.recording == value) {
            return this;
        }
        return new PRaffrayiSettings(value, this.incrementalDeadlock, this.scopeGraphDiff, this.confirmation);
    }

    public final PRaffrayiSettings withIncrementalDeadlock(boolean value) {
        if (this.incrementalDeadlock == value) {
            return this;
        }
        return new PRaffrayiSettings(this.recording, value, this.scopeGraphDiff, this.confirmation);
    }

    public final PRaffrayiSettings withScopeGraphDiff(boolean value) {
        if (this.scopeGraphDiff == value) {
            return this;
        }
        return new PRaffrayiSettings(this.recording, this.incrementalDeadlock, value, this.confirmation);
    }

    public final PRaffrayiSettings withConfirmation(boolean value) {
        if (this.confirmation == value) {
            return this;
        }
        return new PRaffrayiSettings(this.recording, this.incrementalDeadlock, this.scopeGraphDiff, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PRaffrayiSettings && this.equalTo(0, (PRaffrayiSettings)another);
    }

    private boolean equalTo(int synthetic, PRaffrayiSettings another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.recording == another.recording && this.incrementalDeadlock == another.incrementalDeadlock && this.scopeGraphDiff == another.scopeGraphDiff && this.confirmation == another.confirmation;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.recording);
        h += (h << 5) + Boolean.hashCode(this.incrementalDeadlock);
        h += (h << 5) + Boolean.hashCode(this.scopeGraphDiff);
        h += (h << 5) + Boolean.hashCode(this.confirmation);
        return h;
    }

    public String toString() {
        return "PRaffrayiSettings{recording=" + this.recording + ", incrementalDeadlock=" + this.incrementalDeadlock + ", scopeGraphDiff=" + this.scopeGraphDiff + ", confirmation=" + this.confirmation + "}";
    }

    public static PRaffrayiSettings of(boolean recording, boolean incrementalDeadlock, boolean scopeGraphDiff, boolean confirmation) {
        return new PRaffrayiSettings(recording, incrementalDeadlock, scopeGraphDiff, confirmation);
    }

    public static PRaffrayiSettings copyOf(APRaffrayiSettings instance) {
        if (instance instanceof PRaffrayiSettings) {
            return (PRaffrayiSettings)instance;
        }
        return PRaffrayiSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ PRaffrayiSettings(boolean bl, boolean bl2, boolean bl3, boolean bl4, PRaffrayiSettings pRaffrayiSettings) {
        this(bl, bl2, bl3, bl4);
    }

    public static final class Builder {
        private static final long INIT_BIT_RECORDING = 1L;
        private static final long INIT_BIT_INCREMENTAL_DEADLOCK = 2L;
        private static final long INIT_BIT_SCOPE_GRAPH_DIFF = 4L;
        private static final long INIT_BIT_CONFIRMATION = 8L;
        private long initBits = 15L;
        private boolean recording;
        private boolean incrementalDeadlock;
        private boolean scopeGraphDiff;
        private boolean confirmation;

        private Builder() {
        }

        public final Builder from(APRaffrayiSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.recording(instance.recording());
            this.incrementalDeadlock(instance.incrementalDeadlock());
            this.scopeGraphDiff(instance.scopeGraphDiff());
            this.confirmation(instance.confirmation());
            return this;
        }

        public final Builder recording(boolean recording) {
            this.recording = recording;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder incrementalDeadlock(boolean incrementalDeadlock) {
            this.incrementalDeadlock = incrementalDeadlock;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scopeGraphDiff(boolean scopeGraphDiff) {
            this.scopeGraphDiff = scopeGraphDiff;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder confirmation(boolean confirmation) {
            this.confirmation = confirmation;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public PRaffrayiSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PRaffrayiSettings(this.recording, this.incrementalDeadlock, this.scopeGraphDiff, this.confirmation, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("recording");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("incrementalDeadlock");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("scopeGraphDiff");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("confirmation");
            }
            return "Cannot build PRaffrayiSettings, some of required attributes are not set " + attributes;
        }
    }
}

