/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.nameresolution;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.nameresolution.ACAssoc;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.Label;

public final class CAssoc
extends ACAssoc
implements Serializable {
    private final ITerm declaration;
    private final Label label;
    private final ITerm scope;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CAssoc(ITerm declaration, Label label, ITerm scope, IMessageInfo messageInfo) {
        this.declaration = Objects.requireNonNull(declaration, "declaration");
        this.label = Objects.requireNonNull(label, "label");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CAssoc(CAssoc original, ITerm declaration, Label label, ITerm scope, IMessageInfo messageInfo) {
        this.declaration = declaration;
        this.label = label;
        this.scope = scope;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getDeclaration() {
        return this.declaration;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public ITerm getScope() {
        return this.scope;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CAssoc withDeclaration(ITerm value) {
        if (this.declaration == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "declaration");
        return new CAssoc(this, newValue, this.label, this.scope, this.messageInfo);
    }

    public final CAssoc withLabel(Label value) {
        if (this.label == value) {
            return this;
        }
        Label newValue = Objects.requireNonNull(value, "label");
        return new CAssoc(this, this.declaration, newValue, this.scope, this.messageInfo);
    }

    public final CAssoc withScope(ITerm value) {
        if (this.scope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "scope");
        return new CAssoc(this, this.declaration, this.label, newValue, this.messageInfo);
    }

    public final CAssoc withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CAssoc(this, this.declaration, this.label, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CAssoc && this.equalTo(0, (CAssoc)another);
    }

    private boolean equalTo(int synthetic, CAssoc another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.declaration.equals(another.declaration) && this.label.equals(another.label) && this.scope.equals(another.scope) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.declaration.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CAssoc of(ITerm declaration, Label label, ITerm scope, IMessageInfo messageInfo) {
        return new CAssoc(declaration, label, scope, messageInfo);
    }

    public static CAssoc copyOf(ACAssoc instance) {
        if (instance instanceof CAssoc) {
            return (CAssoc)instance;
        }
        return CAssoc.of(instance.getDeclaration(), instance.getLabel(), instance.getScope(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CAssoc(this, this.declaration, this.label, this.scope, this.messageInfo);
    }
}

